// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_ANIMATION_ACTOR_H
#define _HILDONMM_ANIMATION_ACTOR_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonAnimationActor HildonAnimationActor;
typedef struct _HildonAnimationActorClass HildonAnimationActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class AnimationActor_Class; } // namespace Hildon
namespace Hildon
{

/** Animation actor widget for WM-assisted animation effects in the
 * Hildon framework.
 *
 * Hildon::AnimationActor is a widget which represents an animation actor
 * for WM-assisted animation effects in the Hildon framework. It derives
 * from Gtk::Window and can host any widgets much
 * like a normal window. The special features available to the
 * animation actor is the ability to set its position, scale factor
 * and rotation. These parameters are interpreted by Hildon's
 * compositing window manager to alter the on-screen representation of
 * the animation actor window. Bear in mind, however, that by design
 * decision, animation actors are not reactive -- the widgets placed
 * in such window will not receive keyboard, motion or button
 * events. Animation actors are input-transparent -- the input events
 * will be sent to the underlying real windows and widgets.
 *
 * The animation actors may exist in a parented or an unparented
 * state. To be displayed, animations actors must be parented to
 * another top-level window widget. Animation actors display on top
 * (in front) of the standard window contents unless the position
 * (depth, z-coordinate) is specifically adjusted. Animation actors in
 * an unparented state do not display at all.
 *
 * Parented animation actors are placed in the coordinate space of the
 * parent window and visually become a part of the parent window
 * iteslf -- they inherit the transformations and effects enforced by
 * the window manager on the parent window (task switcher animations,
 * minimize events, etc.).
 *
 * All animation actor settings (position, scale, rotation, opacity,
 * depth) can be applied to unparented actors, but will only take
 * effect as the actor is parented to a top-level window and that
 * window is shown. All settings are preserved during
 * unparenting/reparenting.
 *
 * The Hildon::AnimationActor API closely follows the Clutter::Actor
 * API.  Please take a look at the Clutter::Actor description for the
 * modelview transformations order that applies to
 * Hildon::AnimationActor and Clutter::Actor alike.
 *
 * Animation actor widget controls the animation actor as it is
 * transformed by the window manager using ClientMessage X11
 * events. It tries to minimize the amount of such events and couples
 * conceptually related parameters (visibility and opacity, position
 * and depth) to the same message.  The API, however, offers
 * convenience functions for the programmer to be able to modify every
 * parameter individually.
 */

class AnimationActor : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AnimationActor CppObjectType;
  typedef AnimationActor_Class CppClassType;
  typedef HildonAnimationActor BaseObjectType;
  typedef HildonAnimationActorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AnimationActor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AnimationActor_Class;
  static CppClassType animationactor_class_;

  // noncopyable
  AnimationActor(const AnimationActor&);
  AnimationActor& operator=(const AnimationActor&);

protected:
  explicit AnimationActor(const Glib::ConstructParams& construct_params);
  explicit AnimationActor(HildonAnimationActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonAnimationActor*       gobj()       { return reinterpret_cast<HildonAnimationActor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonAnimationActor* gobj() const { return reinterpret_cast<HildonAnimationActor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  

  enum Axis
  {
    AXIS_X = 0,
    AXIS_Y = 1,
    AXIS_Z = 2
  };
  enum Gravity
  {
    GRAVITY_N      = 1,
    GRAVITY_NE     = 2,
    GRAVITY_E      = 3,
    GRAVITY_SE     = 4,
    GRAVITY_S      = 5,
    GRAVITY_SW     = 6,
    GRAVITY_W      = 7,
    GRAVITY_NW     = 8,
    GRAVITY_CENTER = 9
  };

  AnimationActor();

  
  void set_show(bool show, int opacity);
  
  void set_show(bool show = true);
  
  void set_opacity(bool opacity = true);

  
  void set_position(int x, int y, int depth);
  
  void set_position(int x, int y);
  
  void set_depth(int depth);

  
  void set_scale(double x_scale, double y_scale);
  
  void set_rotation(Axis axis, double degrees, int x, int y, int z);

  
  void set_anchor(int x, int y);
  
  void set_anchor_from_gravity(Gravity gravity);

  // Ugly; overloads Gtk::Widget::set_parent()
  
  void set_parent(Gtk::Window& parent);

  // Same here but with Gtk::Widget::unparent(), so it's at least orthagonal
  /** Unparent the animation actor.
   * This will restore the actor's visibility if it was suppressed by
   * being unparented or parented to an unmapped window.
   */
  void unparent();


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::AnimationActor
   */
  Hildon::AnimationActor* wrap(HildonAnimationActor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_ANIMATION_ACTOR_H */

