#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "systray-status-menu-plugin.h"
#include "systray-process.h"

#define _(s) \
	g_dgettext("hildon-systray", (s))

struct _SystrayStatusMenuPlugin {
	HDStatusMenuItem __parent_instance__;
	GtkWidget *dialog;
};

struct _SystrayStatusMenuPluginClass {
	HDStatusMenuItemClass __parent_class__;
};

HD_DEFINE_PLUGIN_MODULE(SystrayStatusMenuPlugin, systray_status_menu_plugin, HD_TYPE_STATUS_MENU_ITEM);

static void
systray_status_menu_plugin_class_finalize(SystrayStatusMenuPluginClass *klass)
{
}

static void
finalize(GObject *obj)
{
	gtk_widget_destroy(SYSTRAY_STATUS_MENU_PLUGIN(obj)->dialog);
}

static void
systray_status_menu_plugin_class_init(SystrayStatusMenuPluginClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS(klass);

	gobject_class->finalize = finalize;
}

static void
print_id(GdkNativeWindow wid, GtkWidget *wnd)
{
	gtk_widget_show(wnd);
}

static void
dlg_response(GtkWidget *dlg, guint response_id, gpointer null)
{
	gtk_widget_hide(dlg);
}

static gboolean
delete_event(GtkWidget *widget, GdkEvent *event, gpointer null)
{
	return TRUE;
}

static void
systray_widget_realize(GtkWidget *systray_dialog, GtkWidget *event_box)
{
	if (GTK_WIDGET_REALIZED(event_box))
		systray_setup(event_box, HILDON_MARGIN_DEFAULT, HILDON_ICON_PIXEL_SIZE_THUMB, (WindowIDCallback)print_id, systray_dialog);
	else
		gtk_widget_realize(event_box);
}

static GtkWidget *
make_dialog()
{
	GtkWidget *wnd, *event_box;

	wnd = g_object_new(GTK_TYPE_DIALOG, "title", _("Notification Area"), NULL);

	g_signal_connect(G_OBJECT(wnd), "response", (GCallback)dlg_response, NULL);
	g_signal_connect(G_OBJECT(wnd), "delete-event", (GCallback)delete_event, NULL);

	event_box = g_object_new(GTK_TYPE_EVENT_BOX, "visible", TRUE, NULL);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(wnd)->vbox), event_box, FALSE, TRUE, 0);

	g_signal_connect(G_OBJECT(wnd), "realize", (GCallback)systray_widget_realize, event_box);
	g_signal_connect_swapped(G_OBJECT(event_box), "realize", (GCallback)systray_widget_realize, wnd);

	if (!GTK_WIDGET_REALIZED(wnd))
		gtk_widget_realize(wnd);
	else
		gtk_widget_realize(event_box);

	return wnd;
}

static void
systray_status_menu_plugin_init(SystrayStatusMenuPlugin *menu_item)
{
	GtkWidget *button, *image;

	image =	g_object_new(GTK_TYPE_IMAGE,
			"visible", TRUE,
			"file",    "/usr/share/icons/hicolor/32x32/hildon/hildon-systray.png",
			"xalign",  0.5,
			"yalign",  0.5,
			NULL);
	gtk_widget_set_size_request(image, 48, 48);

  button = hildon_button_new_with_text(
		HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH, 
		HILDON_BUTTON_ARRANGEMENT_VERTICAL, 
		_("Notification Area"), 
		NULL);
	hildon_button_set_image(HILDON_BUTTON(button), image);
	hildon_button_set_alignment(HILDON_BUTTON(button), 0.0, 0.5, 0.0, 0.0);
	gtk_widget_show(button);

  gtk_container_add (GTK_CONTAINER (menu_item), button);

	gtk_widget_show(GTK_WIDGET(menu_item));

	menu_item->dialog = make_dialog();

	g_signal_connect_swapped(G_OBJECT(button), "clicked", (GCallback)gtk_widget_show, menu_item->dialog);
}
