#include <gtk/gtk.h>

static void
icon_popup_menu(GtkStatusIcon *icon, guint button, guint activate_time, gpointer null)
{
	GtkContainer *menu;
	GtkWidget *menu_item;

	menu = g_object_new(GTK_TYPE_MENU, "visible", TRUE, NULL);
	menu_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, NULL);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate", (GCallback)gtk_main_quit, NULL);

	gtk_container_add(menu, menu_item);
	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, gtk_status_icon_position_menu, icon, button, activate_time);
}

static void
icon_activate(GtkStatusIcon *icon, gpointer null)
{
	icon_popup_menu(icon, 0, GDK_CURRENT_TIME, NULL);
}

static gboolean
flip_icon(GObject *status_icon)
{
	gboolean b = GPOINTER_TO_INT(g_object_get_data(status_icon, "b"));

	b = !b;

	g_object_set_data(status_icon, "b", GINT_TO_POINTER(b));

	g_object_set(status_icon, "icon-name", b ? "gtk-open" : "gtk-close", NULL);

	return TRUE;
}

int
main(int argc, char **argv)
{
	GtkStatusIcon *status_icon;

	gtk_init(&argc, &argv);

	status_icon = g_object_new(GTK_TYPE_STATUS_ICON,
		"icon-name", "gtk-open",
		NULL);

	g_timeout_add(1000, (GSourceFunc)flip_icon, status_icon);
	g_signal_connect(G_OBJECT(status_icon), "popup-menu", (GCallback)icon_popup_menu, NULL);
	g_signal_connect(G_OBJECT(status_icon), "activate", (GCallback)icon_activate, NULL);

	gtk_main();

	return 0;
}
