import gnome.gconf
import gobject, gtk, hildon
import time, thread
import webbrowser
from org.maemo.hermes.engine.provider_oauth import OAuthProvider
import org.maemo.hermes.engine.linkedin.service
from org.maemo.hermes.engine.linkedin.api import LinkedInApi

class Provider(OAuthProvider):
    """LinkedIn provider for Hermes. 

       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""

    LI_API_URL = "https://api.linkedin.com"

    REQUEST_TOKEN_URL = LI_API_URL + "/uas/oauth/requestToken"
    AUTHORIZE_URL = LI_API_URL + "/uas/oauth/authorize"
    ACCESS_TOKEN_URL = LI_API_URL + "/uas/oauth/accessToken"


    # -----------------------------------------------------------------------
    def __init__(self):
        OAuthProvider.__init__(self)
        self._api = LinkedInApi(self.consumer, self.make_api_request)


    # -----------------------------------------------------------------------
    def get_name(self):
        """Return the display name of this service. An icon, of with the lower-case,
           all-alphabetic version of this name is expected to be provided."""
           
        return 'LinkedIn'
    
    
    # -----------------------------------------------------------------------
    def get_urls(self):
        """Return the various URLs needed for OAuth."""
           
        return (self.REQUEST_TOKEN_URL, self.ACCESS_TOKEN_URL, self.AUTHORIZE_URL)

    
    # -----------------------------------------------------------------------
    def service(self, gui_callback):
        """Return the service backend."""
           
        return org.maemo.hermes.engine.linkedin.service.Service(self.get_id(), self._api)


    # -----------------------------------------------------------------------
    def verify_verifier(self, access_token):
        return self._api.verify_verifier(access_token)
