#!/usr/bin/python2.5

import evolution
from org.maemo.hermes.engine.contact import Contact
from org.maemo.hermes.engine.friend import Friend
from org.maemo.hermes.gui.console import ConsoleUICallback
import org.maemo.hermes.engine.facebook.provider
import org.maemo.hermes.engine.twitter.provider
import org.maemo.hermes.engine.gravatar.provider
import org.maemo.hermes.engine.linkedin.provider


providers = [
     org.maemo.hermes.engine.facebook.provider.Provider(),
     org.maemo.hermes.engine.twitter.provider.Provider(),
     org.maemo.hermes.engine.gravatar.provider.Provider(),
     org.maemo.hermes.engine.linkedin.provider.Provider(),
]
             
ui = ConsoleUICallback()

# assemble services, least important (prioritized) first
print "+++ Initialising Services"
services = []
for provider in providers:
    print "Using %s" % (provider.get_name())
    services.append(provider.service(ui))

contacts = []
updated_contacts = set()
unmatched_contacts = set()
overwrite = False

print "\n+++ Pre processing"
addresses = evolution.ebook.open_addressbook('default')
for econtact in addresses.get_all_contacts():
    contact = Contact(addresses, econtact)
    contacts.append(contact)
    for service in services:
        print "    Pre processing %s with %s" % (contact, service.get_name())
        service.pre_process_contact(contact)

print "\n+++ Processing"
for contact in contacts:
    friend = Friend(contact.get_name())
    for service in services:
        print "    Processing %s with %s" % (friend, service.get_name())
        service.process_contact(contact, friend)
    if friend.is_empty():
        print "No service matched %s\n" % friend
        unmatched_contacts.add(contact)
    else:
        print "    Updating contact data for %s\n" % friend
        friend.update_contact(contact, overwrite)
        updated_contacts.add(contact)

print "\n+++ Finalising"
for service in services:
    print "    Finalising service %s" % service.get_name()
    service.finalise(updated_contacts)
