# -*- coding: utf-8 -*-

"""
Module implementing MainWindow.
"""

from PyQt4  import QtGui, QtCore
from Ui_touch import Ui_MainWindow
    
class aMainWindow(QtGui.QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
    def __init__(self, parent = None):
        
        """
        Constructor
        """
        QtGui.QMainWindow.__init__(self, parent)
        self.setupUi(self)
   
        self.x=400
        self.y=240
        self.keyPressed=''
        self.label1=QtCore.QPoint()
        self.label1.setX(10)
        self.label1.setY(30)
        
        self.label2=QtCore.QPoint()
        self.label2.setX(200)
        self.label2.setY(30)
        
        self.label3=QtCore.QPoint()
        self.label3.setX(250)
        self.label3.setY(30)
        
        self.label4=QtCore.QPoint()
        self.label4.setX(10)
        self.label4.setY(60)
        
        self.label5=QtCore.QPoint()
        self.label5.setX(200)
        self.label5.setY(60)
        
        self.label6=QtCore.QPoint()
        self.label6.setX(10)
        self.label6.setY(90)
        
        self.setGeometry(0,0,800, 480)
        self.setWindowTitle('Touch Events')
        self.paint = QtGui.QPainter()
     

    def paintEvent(self, event):
        #Start the painter
        self.paint.begin(self)

        self.paint.setFont(QtGui.QFont('Ariel', 20))
        
        #Draw the Key pressed
        self.paint.setPen(QtGui.QColor(0,0,255))
        self.paint.drawText(self.label4,"Key Pressed")
        self.paint.drawText(self.label5,self.keyPressed)

        #Draw a circle x,y,Width,Height souround the current mouse postion
        self.paint.setPen(QtGui.QColor(255,0, 0))
        self.paint.drawEllipse(self.x-15, self.y-15, 30, 30)
        self.paint.drawLine(0,self.y,self.width()-1,self.y)
        self.paint.drawLine(self.x,0,self.x,self.height()-1)

 
        #Draw Mouse Position
        self.paint.setPen(QtGui.QColor(0, 255, 0))
        self.paint.drawText(self.label1,"Mouse Position")
        self.paint.drawText(self.label6,"Press q to quit")
        self.paint.drawText(self.label2,str(self.x))
        self.paint.drawText(self.label3,str(self.y))
        self.paint.drawPoint(self.x, self.y)
        #End the painter
        self.paint.end()
        
    def mousePressEvent(self, event):
        self.mousePressPos = QtCore.QPoint(event.pos())
   
        self.x = self.mousePressPos.x()
        self.y = self.mousePressPos.y()
        event.accept()
        self.keyPressed ="Mouse Pressed"
        #update calls the paintEvent
        self.update()
   
    
    def touchEvent(self, event):
        self.touch=event.pressure()

        print self.touch
        event.accept()
        #update calls the paintEvent
        self.update()
     

    def mouseMoveEvent(self, event):
        self.mousePressPos = QtCore.QPoint(event.pos())
        if self.mousePressPos.isNull():
            event.ignore()
            return
        self.x = self.mousePressPos.x()
        self.y = self.mousePressPos.y()
        event.accept()
        self.update()

    def mouseReleaseEvent(self, event):
        self.mousePressPos = QtCore.QPoint()
        self.keyPressed ="Mouse Released"
        event.accept()
        self.update()
        
    def keyPressEvent(self, event):

        self.keyPressed=event.text()
        event.accept()
        if self.keyPressed== "q":
            self.close()
        else :self.update()
    

def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
    





