// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "RoomXML.hpp"

namespace rxml
{
  // RoomXML
  // 

  const RoomXML::name_type& RoomXML::
  name () const
  {
    return this->name_.get ();
  }

  RoomXML::name_type& RoomXML::
  name ()
  {
    return this->name_.get ();
  }

  void RoomXML::
  name (const name_type& name)
  {
    this->name_.set (name);
  }

  void RoomXML::
  name (::std::auto_ptr< name_type > name)
  {
    this->name_.set (name);
  }

  const RoomXML::scenery_type& RoomXML::
  scenery () const
  {
    return this->scenery_.get ();
  }

  RoomXML::scenery_type& RoomXML::
  scenery ()
  {
    return this->scenery_.get ();
  }

  void RoomXML::
  scenery (const scenery_type& scenery)
  {
    this->scenery_.set (scenery);
  }

  void RoomXML::
  scenery (::std::auto_ptr< scenery_type > scenery)
  {
    this->scenery_.set (scenery);
  }

  const RoomXML::xTiles_type& RoomXML::
  xTiles () const
  {
    return this->xTiles_.get ();
  }

  RoomXML::xTiles_type& RoomXML::
  xTiles ()
  {
    return this->xTiles_.get ();
  }

  void RoomXML::
  xTiles (const xTiles_type& xTiles)
  {
    this->xTiles_.set (xTiles);
  }

  const RoomXML::yTiles_type& RoomXML::
  yTiles () const
  {
    return this->yTiles_.get ();
  }

  RoomXML::yTiles_type& RoomXML::
  yTiles ()
  {
    return this->yTiles_.get ();
  }

  void RoomXML::
  yTiles (const yTiles_type& yTiles)
  {
    this->yTiles_.set (yTiles);
  }

  const RoomXML::width_type& RoomXML::
  width () const
  {
    return this->width_.get ();
  }

  RoomXML::width_type& RoomXML::
  width ()
  {
    return this->width_.get ();
  }

  void RoomXML::
  width (const width_type& width)
  {
    this->width_.set (width);
  }

  const RoomXML::floorType_type& RoomXML::
  floorType () const
  {
    return this->floorType_.get ();
  }

  RoomXML::floorType_type& RoomXML::
  floorType ()
  {
    return this->floorType_.get ();
  }

  void RoomXML::
  floorType (const floorType_type& floorType)
  {
    this->floorType_.set (floorType);
  }

  void RoomXML::
  floorType (::std::auto_ptr< floorType_type > floorType)
  {
    this->floorType_.set (floorType);
  }

  const RoomXML::deltaX_optional& RoomXML::
  deltaX () const
  {
    return this->deltaX_;
  }

  RoomXML::deltaX_optional& RoomXML::
  deltaX ()
  {
    return this->deltaX_;
  }

  void RoomXML::
  deltaX (const deltaX_type& deltaX)
  {
    this->deltaX_.set (deltaX);
  }

  void RoomXML::
  deltaX (const deltaX_optional& deltaX)
  {
    this->deltaX_ = deltaX;
  }

  const RoomXML::deltaY_optional& RoomXML::
  deltaY () const
  {
    return this->deltaY_;
  }

  RoomXML::deltaY_optional& RoomXML::
  deltaY ()
  {
    return this->deltaY_;
  }

  void RoomXML::
  deltaY (const deltaY_type& deltaY)
  {
    this->deltaY_.set (deltaY);
  }

  void RoomXML::
  deltaY (const deltaY_optional& deltaY)
  {
    this->deltaY_ = deltaY;
  }

  const RoomXML::triple_room_data_optional& RoomXML::
  triple_room_data () const
  {
    return this->triple_room_data_;
  }

  RoomXML::triple_room_data_optional& RoomXML::
  triple_room_data ()
  {
    return this->triple_room_data_;
  }

  void RoomXML::
  triple_room_data (const triple_room_data_type& triple_room_data)
  {
    this->triple_room_data_.set (triple_room_data);
  }

  void RoomXML::
  triple_room_data (const triple_room_data_optional& triple_room_data)
  {
    this->triple_room_data_ = triple_room_data;
  }

  void RoomXML::
  triple_room_data (::std::auto_ptr< triple_room_data_type > triple_room_data)
  {
    this->triple_room_data_.set (triple_room_data);
  }

  const RoomXML::floor_type& RoomXML::
  floor () const
  {
    return this->floor_.get ();
  }

  RoomXML::floor_type& RoomXML::
  floor ()
  {
    return this->floor_.get ();
  }

  void RoomXML::
  floor (const floor_type& floor)
  {
    this->floor_.set (floor);
  }

  void RoomXML::
  floor (::std::auto_ptr< floor_type > floor)
  {
    this->floor_.set (floor);
  }

  const RoomXML::walls_optional& RoomXML::
  walls () const
  {
    return this->walls_;
  }

  RoomXML::walls_optional& RoomXML::
  walls ()
  {
    return this->walls_;
  }

  void RoomXML::
  walls (const walls_type& walls)
  {
    this->walls_.set (walls);
  }

  void RoomXML::
  walls (const walls_optional& walls)
  {
    this->walls_ = walls;
  }

  void RoomXML::
  walls (::std::auto_ptr< walls_type > walls)
  {
    this->walls_.set (walls);
  }

  const RoomXML::items_type& RoomXML::
  items () const
  {
    return this->items_.get ();
  }

  RoomXML::items_type& RoomXML::
  items ()
  {
    return this->items_.get ();
  }

  void RoomXML::
  items (const items_type& items)
  {
    this->items_.set (items);
  }

  void RoomXML::
  items (::std::auto_ptr< items_type > items)
  {
    this->items_.set (items);
  }


  // floorType
  // 

  floorType::
  floorType (value v)
  : ::xml_schema::string (_xsd_floorType_literals_[v])
  {
  }

  floorType::
  floorType (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  floorType::
  floorType (const floorType& v,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  floorType& floorType::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_floorType_literals_[v]);

    return *this;
  }


  // triple_room_data
  // 

  const triple_room_data::northeast_optional& triple_room_data::
  northeast () const
  {
    return this->northeast_;
  }

  triple_room_data::northeast_optional& triple_room_data::
  northeast ()
  {
    return this->northeast_;
  }

  void triple_room_data::
  northeast (const northeast_type& northeast)
  {
    this->northeast_.set (northeast);
  }

  void triple_room_data::
  northeast (const northeast_optional& northeast)
  {
    this->northeast_ = northeast;
  }

  void triple_room_data::
  northeast (::std::auto_ptr< northeast_type > northeast)
  {
    this->northeast_.set (northeast);
  }

  const triple_room_data::southeast_optional& triple_room_data::
  southeast () const
  {
    return this->southeast_;
  }

  triple_room_data::southeast_optional& triple_room_data::
  southeast ()
  {
    return this->southeast_;
  }

  void triple_room_data::
  southeast (const southeast_type& southeast)
  {
    this->southeast_.set (southeast);
  }

  void triple_room_data::
  southeast (const southeast_optional& southeast)
  {
    this->southeast_ = southeast;
  }

  void triple_room_data::
  southeast (::std::auto_ptr< southeast_type > southeast)
  {
    this->southeast_.set (southeast);
  }

  const triple_room_data::northwest_optional& triple_room_data::
  northwest () const
  {
    return this->northwest_;
  }

  triple_room_data::northwest_optional& triple_room_data::
  northwest ()
  {
    return this->northwest_;
  }

  void triple_room_data::
  northwest (const northwest_type& northwest)
  {
    this->northwest_.set (northwest);
  }

  void triple_room_data::
  northwest (const northwest_optional& northwest)
  {
    this->northwest_ = northwest;
  }

  void triple_room_data::
  northwest (::std::auto_ptr< northwest_type > northwest)
  {
    this->northwest_.set (northwest);
  }

  const triple_room_data::southwest_optional& triple_room_data::
  southwest () const
  {
    return this->southwest_;
  }

  triple_room_data::southwest_optional& triple_room_data::
  southwest ()
  {
    return this->southwest_;
  }

  void triple_room_data::
  southwest (const southwest_type& southwest)
  {
    this->southwest_.set (southwest);
  }

  void triple_room_data::
  southwest (const southwest_optional& southwest)
  {
    this->southwest_ = southwest;
  }

  void triple_room_data::
  southwest (::std::auto_ptr< southwest_type > southwest)
  {
    this->southwest_.set (southwest);
  }

  const triple_room_data::eastnorth_optional& triple_room_data::
  eastnorth () const
  {
    return this->eastnorth_;
  }

  triple_room_data::eastnorth_optional& triple_room_data::
  eastnorth ()
  {
    return this->eastnorth_;
  }

  void triple_room_data::
  eastnorth (const eastnorth_type& eastnorth)
  {
    this->eastnorth_.set (eastnorth);
  }

  void triple_room_data::
  eastnorth (const eastnorth_optional& eastnorth)
  {
    this->eastnorth_ = eastnorth;
  }

  void triple_room_data::
  eastnorth (::std::auto_ptr< eastnorth_type > eastnorth)
  {
    this->eastnorth_.set (eastnorth);
  }

  const triple_room_data::eastsouth_optional& triple_room_data::
  eastsouth () const
  {
    return this->eastsouth_;
  }

  triple_room_data::eastsouth_optional& triple_room_data::
  eastsouth ()
  {
    return this->eastsouth_;
  }

  void triple_room_data::
  eastsouth (const eastsouth_type& eastsouth)
  {
    this->eastsouth_.set (eastsouth);
  }

  void triple_room_data::
  eastsouth (const eastsouth_optional& eastsouth)
  {
    this->eastsouth_ = eastsouth;
  }

  void triple_room_data::
  eastsouth (::std::auto_ptr< eastsouth_type > eastsouth)
  {
    this->eastsouth_.set (eastsouth);
  }

  const triple_room_data::westnorth_optional& triple_room_data::
  westnorth () const
  {
    return this->westnorth_;
  }

  triple_room_data::westnorth_optional& triple_room_data::
  westnorth ()
  {
    return this->westnorth_;
  }

  void triple_room_data::
  westnorth (const westnorth_type& westnorth)
  {
    this->westnorth_.set (westnorth);
  }

  void triple_room_data::
  westnorth (const westnorth_optional& westnorth)
  {
    this->westnorth_ = westnorth;
  }

  void triple_room_data::
  westnorth (::std::auto_ptr< westnorth_type > westnorth)
  {
    this->westnorth_.set (westnorth);
  }

  const triple_room_data::westsouth_optional& triple_room_data::
  westsouth () const
  {
    return this->westsouth_;
  }

  triple_room_data::westsouth_optional& triple_room_data::
  westsouth ()
  {
    return this->westsouth_;
  }

  void triple_room_data::
  westsouth (const westsouth_type& westsouth)
  {
    this->westsouth_.set (westsouth);
  }

  void triple_room_data::
  westsouth (const westsouth_optional& westsouth)
  {
    this->westsouth_ = westsouth;
  }

  void triple_room_data::
  westsouth (::std::auto_ptr< westsouth_type > westsouth)
  {
    this->westsouth_.set (westsouth);
  }

  const triple_room_data::bound_x_type& triple_room_data::
  bound_x () const
  {
    return this->bound_x_.get ();
  }

  triple_room_data::bound_x_type& triple_room_data::
  bound_x ()
  {
    return this->bound_x_.get ();
  }

  void triple_room_data::
  bound_x (const bound_x_type& bound_x)
  {
    this->bound_x_.set (bound_x);
  }

  void triple_room_data::
  bound_x (::std::auto_ptr< bound_x_type > bound_x)
  {
    this->bound_x_.set (bound_x);
  }

  const triple_room_data::bound_y_type& triple_room_data::
  bound_y () const
  {
    return this->bound_y_.get ();
  }

  triple_room_data::bound_y_type& triple_room_data::
  bound_y ()
  {
    return this->bound_y_.get ();
  }

  void triple_room_data::
  bound_y (const bound_y_type& bound_y)
  {
    this->bound_y_.set (bound_y);
  }

  void triple_room_data::
  bound_y (::std::auto_ptr< bound_y_type > bound_y)
  {
    this->bound_y_.set (bound_y);
  }


  // floor
  // 

  const floor::tile_sequence& floor::
  tile () const
  {
    return this->tile_;
  }

  floor::tile_sequence& floor::
  tile ()
  {
    return this->tile_;
  }

  void floor::
  tile (const tile_sequence& tile)
  {
    this->tile_ = tile;
  }


  // walls
  // 

  const walls::wall_sequence& walls::
  wall () const
  {
    return this->wall_;
  }

  walls::wall_sequence& walls::
  wall ()
  {
    return this->wall_;
  }

  void walls::
  wall (const wall_sequence& wall)
  {
    this->wall_ = wall;
  }


  // items
  // 

  const items::item_sequence& items::
  item () const
  {
    return this->item_;
  }

  items::item_sequence& items::
  item ()
  {
    return this->item_;
  }

  void items::
  item (const item_sequence& item)
  {
    this->item_ = item;
  }


  // northeast
  // 

  const northeast::x_type& northeast::
  x () const
  {
    return this->x_.get ();
  }

  northeast::x_type& northeast::
  x ()
  {
    return this->x_.get ();
  }

  void northeast::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const northeast::y_type& northeast::
  y () const
  {
    return this->y_.get ();
  }

  northeast::y_type& northeast::
  y ()
  {
    return this->y_.get ();
  }

  void northeast::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // southeast
  // 

  const southeast::x_type& southeast::
  x () const
  {
    return this->x_.get ();
  }

  southeast::x_type& southeast::
  x ()
  {
    return this->x_.get ();
  }

  void southeast::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const southeast::y_type& southeast::
  y () const
  {
    return this->y_.get ();
  }

  southeast::y_type& southeast::
  y ()
  {
    return this->y_.get ();
  }

  void southeast::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // northwest
  // 

  const northwest::x_type& northwest::
  x () const
  {
    return this->x_.get ();
  }

  northwest::x_type& northwest::
  x ()
  {
    return this->x_.get ();
  }

  void northwest::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const northwest::y_type& northwest::
  y () const
  {
    return this->y_.get ();
  }

  northwest::y_type& northwest::
  y ()
  {
    return this->y_.get ();
  }

  void northwest::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // southwest
  // 

  const southwest::x_type& southwest::
  x () const
  {
    return this->x_.get ();
  }

  southwest::x_type& southwest::
  x ()
  {
    return this->x_.get ();
  }

  void southwest::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const southwest::y_type& southwest::
  y () const
  {
    return this->y_.get ();
  }

  southwest::y_type& southwest::
  y ()
  {
    return this->y_.get ();
  }

  void southwest::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // eastnorth
  // 

  const eastnorth::x_type& eastnorth::
  x () const
  {
    return this->x_.get ();
  }

  eastnorth::x_type& eastnorth::
  x ()
  {
    return this->x_.get ();
  }

  void eastnorth::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const eastnorth::y_type& eastnorth::
  y () const
  {
    return this->y_.get ();
  }

  eastnorth::y_type& eastnorth::
  y ()
  {
    return this->y_.get ();
  }

  void eastnorth::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // eastsouth
  // 

  const eastsouth::x_type& eastsouth::
  x () const
  {
    return this->x_.get ();
  }

  eastsouth::x_type& eastsouth::
  x ()
  {
    return this->x_.get ();
  }

  void eastsouth::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const eastsouth::y_type& eastsouth::
  y () const
  {
    return this->y_.get ();
  }

  eastsouth::y_type& eastsouth::
  y ()
  {
    return this->y_.get ();
  }

  void eastsouth::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // westnorth
  // 

  const westnorth::x_type& westnorth::
  x () const
  {
    return this->x_.get ();
  }

  westnorth::x_type& westnorth::
  x ()
  {
    return this->x_.get ();
  }

  void westnorth::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const westnorth::y_type& westnorth::
  y () const
  {
    return this->y_.get ();
  }

  westnorth::y_type& westnorth::
  y ()
  {
    return this->y_.get ();
  }

  void westnorth::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // westsouth
  // 

  const westsouth::x_type& westsouth::
  x () const
  {
    return this->x_.get ();
  }

  westsouth::x_type& westsouth::
  x ()
  {
    return this->x_.get ();
  }

  void westsouth::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const westsouth::y_type& westsouth::
  y () const
  {
    return this->y_.get ();
  }

  westsouth::y_type& westsouth::
  y ()
  {
    return this->y_.get ();
  }

  void westsouth::
  y (const y_type& y)
  {
    this->y_.set (y);
  }


  // bound_x
  // 

  const bound_x::minimum_type& bound_x::
  minimum () const
  {
    return this->minimum_.get ();
  }

  bound_x::minimum_type& bound_x::
  minimum ()
  {
    return this->minimum_.get ();
  }

  void bound_x::
  minimum (const minimum_type& minimum)
  {
    this->minimum_.set (minimum);
  }

  const bound_x::maximum_type& bound_x::
  maximum () const
  {
    return this->maximum_.get ();
  }

  bound_x::maximum_type& bound_x::
  maximum ()
  {
    return this->maximum_.get ();
  }

  void bound_x::
  maximum (const maximum_type& maximum)
  {
    this->maximum_.set (maximum);
  }


  // bound_y
  // 

  const bound_y::minimum_type& bound_y::
  minimum () const
  {
    return this->minimum_.get ();
  }

  bound_y::minimum_type& bound_y::
  minimum ()
  {
    return this->minimum_.get ();
  }

  void bound_y::
  minimum (const minimum_type& minimum)
  {
    this->minimum_.set (minimum);
  }

  const bound_y::maximum_type& bound_y::
  maximum () const
  {
    return this->maximum_.get ();
  }

  bound_y::maximum_type& bound_y::
  maximum ()
  {
    return this->maximum_.get ();
  }

  void bound_y::
  maximum (const maximum_type& maximum)
  {
    this->maximum_.set (maximum);
  }


  // tile
  // 

  const tile::x_type& tile::
  x () const
  {
    return this->x_.get ();
  }

  tile::x_type& tile::
  x ()
  {
    return this->x_.get ();
  }

  void tile::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const tile::y_type& tile::
  y () const
  {
    return this->y_.get ();
  }

  tile::y_type& tile::
  y ()
  {
    return this->y_.get ();
  }

  void tile::
  y (const y_type& y)
  {
    this->y_.set (y);
  }

  const tile::offsetX_type& tile::
  offsetX () const
  {
    return this->offsetX_.get ();
  }

  tile::offsetX_type& tile::
  offsetX ()
  {
    return this->offsetX_.get ();
  }

  void tile::
  offsetX (const offsetX_type& offsetX)
  {
    this->offsetX_.set (offsetX);
  }

  const tile::offsetY_type& tile::
  offsetY () const
  {
    return this->offsetY_.get ();
  }

  tile::offsetY_type& tile::
  offsetY ()
  {
    return this->offsetY_.get ();
  }

  void tile::
  offsetY (const offsetY_type& offsetY)
  {
    this->offsetY_.set (offsetY);
  }

  const tile::bitmap_type& tile::
  bitmap () const
  {
    return this->bitmap_.get ();
  }

  tile::bitmap_type& tile::
  bitmap ()
  {
    return this->bitmap_.get ();
  }

  void tile::
  bitmap (const bitmap_type& bitmap)
  {
    this->bitmap_.set (bitmap);
  }

  void tile::
  bitmap (::std::auto_ptr< bitmap_type > bitmap)
  {
    this->bitmap_.set (bitmap);
  }


  // wall
  // 

  const wall::axis_type& wall::
  axis () const
  {
    return this->axis_.get ();
  }

  wall::axis_type& wall::
  axis ()
  {
    return this->axis_.get ();
  }

  void wall::
  axis (const axis_type& axis)
  {
    this->axis_.set (axis);
  }

  void wall::
  axis (::std::auto_ptr< axis_type > axis)
  {
    this->axis_.set (axis);
  }

  const wall::index_type& wall::
  index () const
  {
    return this->index_.get ();
  }

  wall::index_type& wall::
  index ()
  {
    return this->index_.get ();
  }

  void wall::
  index (const index_type& index)
  {
    this->index_.set (index);
  }

  const wall::bitmap_type& wall::
  bitmap () const
  {
    return this->bitmap_.get ();
  }

  wall::bitmap_type& wall::
  bitmap ()
  {
    return this->bitmap_.get ();
  }

  void wall::
  bitmap (const bitmap_type& bitmap)
  {
    this->bitmap_.set (bitmap);
  }

  void wall::
  bitmap (::std::auto_ptr< bitmap_type > bitmap)
  {
    this->bitmap_.set (bitmap);
  }


  // item
  // 

  const item::label_type& item::
  label () const
  {
    return this->label_.get ();
  }

  item::label_type& item::
  label ()
  {
    return this->label_.get ();
  }

  void item::
  label (const label_type& label)
  {
    this->label_.set (label);
  }

  const item::direction_type& item::
  direction () const
  {
    return this->direction_.get ();
  }

  item::direction_type& item::
  direction ()
  {
    return this->direction_.get ();
  }

  void item::
  direction (const direction_type& direction)
  {
    this->direction_.set (direction);
  }

  void item::
  direction (::std::auto_ptr< direction_type > direction)
  {
    this->direction_.set (direction);
  }

  const item::behavior_type& item::
  behavior () const
  {
    return this->behavior_.get ();
  }

  item::behavior_type& item::
  behavior ()
  {
    return this->behavior_.get ();
  }

  void item::
  behavior (const behavior_type& behavior)
  {
    this->behavior_.set (behavior);
  }

  const item::type_type& item::
  type () const
  {
    return this->type_.get ();
  }

  item::type_type& item::
  type ()
  {
    return this->type_.get ();
  }

  void item::
  type (const type_type& type)
  {
    this->type_.set (type);
  }

  void item::
  type (::std::auto_ptr< type_type > type)
  {
    this->type_.set (type);
  }

  const item::extra_sequence& item::
  extra () const
  {
    return this->extra_;
  }

  item::extra_sequence& item::
  extra ()
  {
    return this->extra_;
  }

  void item::
  extra (const extra_sequence& extra)
  {
    this->extra_ = extra;
  }

  const item::x_type& item::
  x () const
  {
    return this->x_.get ();
  }

  item::x_type& item::
  x ()
  {
    return this->x_.get ();
  }

  void item::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  const item::y_type& item::
  y () const
  {
    return this->y_.get ();
  }

  item::y_type& item::
  y ()
  {
    return this->y_.get ();
  }

  void item::
  y (const y_type& y)
  {
    this->y_.set (y);
  }

  const item::z_type& item::
  z () const
  {
    return this->z_.get ();
  }

  item::z_type& item::
  z ()
  {
    return this->z_.get ();
  }

  void item::
  z (const z_type& z)
  {
    this->z_.set (z);
  }


  // axis
  // 

  axis::
  axis (value v)
  : ::xml_schema::string (_xsd_axis_literals_[v])
  {
  }

  axis::
  axis (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  axis::
  axis (const axis& v,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  axis& axis::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_axis_literals_[v]);

    return *this;
  }


  // direction
  // 

  direction::
  direction (value v)
  : ::xml_schema::string (_xsd_direction_literals_[v])
  {
  }

  direction::
  direction (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  direction::
  direction (const direction& v,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  direction& direction::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_direction_literals_[v]);

    return *this;
  }


  // type
  // 

  type::
  type (value v)
  : ::xml_schema::string (_xsd_type_literals_[v])
  {
  }

  type::
  type (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  type::
  type (const type& v,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  type& type::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_type_literals_[v]);

    return *this;
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

namespace rxml
{
  // RoomXML
  //

  RoomXML::
  RoomXML (const name_type& name,
           const scenery_type& scenery,
           const xTiles_type& xTiles,
           const yTiles_type& yTiles,
           const width_type& width,
           const floorType_type& floorType,
           const floor_type& floor,
           const items_type& items)
  : ::xml_schema::type (),
    name_ (name, ::xml_schema::flags (), this),
    scenery_ (scenery, ::xml_schema::flags (), this),
    xTiles_ (xTiles, ::xml_schema::flags (), this),
    yTiles_ (yTiles, ::xml_schema::flags (), this),
    width_ (width, ::xml_schema::flags (), this),
    floorType_ (floorType, ::xml_schema::flags (), this),
    deltaX_ (::xml_schema::flags (), this),
    deltaY_ (::xml_schema::flags (), this),
    triple_room_data_ (::xml_schema::flags (), this),
    floor_ (floor, ::xml_schema::flags (), this),
    walls_ (::xml_schema::flags (), this),
    items_ (items, ::xml_schema::flags (), this)
  {
  }

  RoomXML::
  RoomXML (const RoomXML& x,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    name_ (x.name_, f, this),
    scenery_ (x.scenery_, f, this),
    xTiles_ (x.xTiles_, f, this),
    yTiles_ (x.yTiles_, f, this),
    width_ (x.width_, f, this),
    floorType_ (x.floorType_, f, this),
    deltaX_ (x.deltaX_, f, this),
    deltaY_ (x.deltaY_, f, this),
    triple_room_data_ (x.triple_room_data_, f, this),
    floor_ (x.floor_, f, this),
    walls_ (x.walls_, f, this),
    items_ (x.items_, f, this)
  {
  }

  RoomXML::
  RoomXML (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    name_ (f, this),
    scenery_ (f, this),
    xTiles_ (f, this),
    yTiles_ (f, this),
    width_ (f, this),
    floorType_ (f, this),
    deltaX_ (f, this),
    deltaY_ (f, this),
    triple_room_data_ (f, this),
    floor_ (f, this),
    walls_ (f, this),
    items_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void RoomXML::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // name
      //
      if (n.name () == "name" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< name_type > r (
          name_traits::create (i, f, this));

        if (!name_.present ())
        {
          this->name (r);
          continue;
        }
      }

      // scenery
      //
      if (n.name () == "scenery" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< scenery_type > r (
          scenery_traits::create (i, f, this));

        if (!scenery_.present ())
        {
          this->scenery (r);
          continue;
        }
      }

      // xTiles
      //
      if (n.name () == "xTiles" && n.namespace_ ().empty ())
      {
        if (!xTiles_.present ())
        {
          this->xTiles (xTiles_traits::create (i, f, this));
          continue;
        }
      }

      // yTiles
      //
      if (n.name () == "yTiles" && n.namespace_ ().empty ())
      {
        if (!yTiles_.present ())
        {
          this->yTiles (yTiles_traits::create (i, f, this));
          continue;
        }
      }

      // width
      //
      if (n.name () == "width" && n.namespace_ ().empty ())
      {
        if (!width_.present ())
        {
          this->width (width_traits::create (i, f, this));
          continue;
        }
      }

      // floorType
      //
      if (n.name () == "floorType" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< floorType_type > r (
          floorType_traits::create (i, f, this));

        if (!floorType_.present ())
        {
          this->floorType (r);
          continue;
        }
      }

      // deltaX
      //
      if (n.name () == "deltaX" && n.namespace_ ().empty ())
      {
        if (!this->deltaX ())
        {
          this->deltaX (deltaX_traits::create (i, f, this));
          continue;
        }
      }

      // deltaY
      //
      if (n.name () == "deltaY" && n.namespace_ ().empty ())
      {
        if (!this->deltaY ())
        {
          this->deltaY (deltaY_traits::create (i, f, this));
          continue;
        }
      }

      // triple_room_data
      //
      if (n.name () == "triple-room-data" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< triple_room_data_type > r (
          triple_room_data_traits::create (i, f, this));

        if (!this->triple_room_data ())
        {
          this->triple_room_data (r);
          continue;
        }
      }

      // floor
      //
      if (n.name () == "floor" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< floor_type > r (
          floor_traits::create (i, f, this));

        if (!floor_.present ())
        {
          this->floor (r);
          continue;
        }
      }

      // walls
      //
      if (n.name () == "walls" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< walls_type > r (
          walls_traits::create (i, f, this));

        if (!this->walls ())
        {
          this->walls (r);
          continue;
        }
      }

      // items
      //
      if (n.name () == "items" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< items_type > r (
          items_traits::create (i, f, this));

        if (!items_.present ())
        {
          this->items (r);
          continue;
        }
      }

      break;
    }

    if (!name_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "name",
        "");
    }

    if (!scenery_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "scenery",
        "");
    }

    if (!xTiles_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "xTiles",
        "");
    }

    if (!yTiles_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "yTiles",
        "");
    }

    if (!width_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "width",
        "");
    }

    if (!floorType_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "floorType",
        "");
    }

    if (!floor_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "floor",
        "");
    }

    if (!items_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "items",
        "");
    }
  }

  RoomXML* RoomXML::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new RoomXML (*this, f, c);
  }

  // floorType
  //

  floorType::
  floorType (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_floorType_convert ();
  }

  floorType::
  floorType (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_floorType_convert ();
  }

  floorType::
  floorType (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_floorType_convert ();
  }

  floorType* floorType::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new floorType (*this, f, c);
  }

  floorType::value floorType::
  _xsd_floorType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_floorType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_floorType_indexes_,
                      _xsd_floorType_indexes_ + 3,
                      *this,
                      c));

    if (i == _xsd_floorType_indexes_ + 3 || _xsd_floorType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const floorType::
  _xsd_floorType_literals_[3] =
  {
    "none",
    "regular",
    "mortal"
  };

  const floorType::value floorType::
  _xsd_floorType_indexes_[3] =
  {
    ::rxml::floorType::mortal,
    ::rxml::floorType::none,
    ::rxml::floorType::regular
  };

  // triple_room_data
  //

  triple_room_data::
  triple_room_data (const bound_x_type& bound_x,
                    const bound_y_type& bound_y)
  : ::xml_schema::type (),
    northeast_ (::xml_schema::flags (), this),
    southeast_ (::xml_schema::flags (), this),
    northwest_ (::xml_schema::flags (), this),
    southwest_ (::xml_schema::flags (), this),
    eastnorth_ (::xml_schema::flags (), this),
    eastsouth_ (::xml_schema::flags (), this),
    westnorth_ (::xml_schema::flags (), this),
    westsouth_ (::xml_schema::flags (), this),
    bound_x_ (bound_x, ::xml_schema::flags (), this),
    bound_y_ (bound_y, ::xml_schema::flags (), this)
  {
  }

  triple_room_data::
  triple_room_data (const triple_room_data& x,
                    ::xml_schema::flags f,
                    ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    northeast_ (x.northeast_, f, this),
    southeast_ (x.southeast_, f, this),
    northwest_ (x.northwest_, f, this),
    southwest_ (x.southwest_, f, this),
    eastnorth_ (x.eastnorth_, f, this),
    eastsouth_ (x.eastsouth_, f, this),
    westnorth_ (x.westnorth_, f, this),
    westsouth_ (x.westsouth_, f, this),
    bound_x_ (x.bound_x_, f, this),
    bound_y_ (x.bound_y_, f, this)
  {
  }

  triple_room_data::
  triple_room_data (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    northeast_ (f, this),
    southeast_ (f, this),
    northwest_ (f, this),
    southwest_ (f, this),
    eastnorth_ (f, this),
    eastsouth_ (f, this),
    westnorth_ (f, this),
    westsouth_ (f, this),
    bound_x_ (f, this),
    bound_y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void triple_room_data::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // northeast
      //
      if (n.name () == "northeast" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< northeast_type > r (
          northeast_traits::create (i, f, this));

        if (!this->northeast ())
        {
          this->northeast (r);
          continue;
        }
      }

      // southeast
      //
      if (n.name () == "southeast" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< southeast_type > r (
          southeast_traits::create (i, f, this));

        if (!this->southeast ())
        {
          this->southeast (r);
          continue;
        }
      }

      // northwest
      //
      if (n.name () == "northwest" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< northwest_type > r (
          northwest_traits::create (i, f, this));

        if (!this->northwest ())
        {
          this->northwest (r);
          continue;
        }
      }

      // southwest
      //
      if (n.name () == "southwest" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< southwest_type > r (
          southwest_traits::create (i, f, this));

        if (!this->southwest ())
        {
          this->southwest (r);
          continue;
        }
      }

      // eastnorth
      //
      if (n.name () == "eastnorth" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< eastnorth_type > r (
          eastnorth_traits::create (i, f, this));

        if (!this->eastnorth ())
        {
          this->eastnorth (r);
          continue;
        }
      }

      // eastsouth
      //
      if (n.name () == "eastsouth" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< eastsouth_type > r (
          eastsouth_traits::create (i, f, this));

        if (!this->eastsouth ())
        {
          this->eastsouth (r);
          continue;
        }
      }

      // westnorth
      //
      if (n.name () == "westnorth" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< westnorth_type > r (
          westnorth_traits::create (i, f, this));

        if (!this->westnorth ())
        {
          this->westnorth (r);
          continue;
        }
      }

      // westsouth
      //
      if (n.name () == "westsouth" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< westsouth_type > r (
          westsouth_traits::create (i, f, this));

        if (!this->westsouth ())
        {
          this->westsouth (r);
          continue;
        }
      }

      // bound_x
      //
      if (n.name () == "bound-x" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< bound_x_type > r (
          bound_x_traits::create (i, f, this));

        if (!bound_x_.present ())
        {
          this->bound_x (r);
          continue;
        }
      }

      // bound_y
      //
      if (n.name () == "bound-y" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< bound_y_type > r (
          bound_y_traits::create (i, f, this));

        if (!bound_y_.present ())
        {
          this->bound_y (r);
          continue;
        }
      }

      break;
    }

    if (!bound_x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "bound-x",
        "");
    }

    if (!bound_y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "bound-y",
        "");
    }
  }

  triple_room_data* triple_room_data::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new triple_room_data (*this, f, c);
  }

  // floor
  //

  floor::
  floor ()
  : ::xml_schema::type (),
    tile_ (::xml_schema::flags (), this)
  {
  }

  floor::
  floor (const floor& x,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    tile_ (x.tile_, f, this)
  {
  }

  floor::
  floor (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    tile_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void floor::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // tile
      //
      if (n.name () == "tile" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< tile_type > r (
          tile_traits::create (i, f, this));

        this->tile ().push_back (r);
        continue;
      }

      break;
    }
  }

  floor* floor::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new floor (*this, f, c);
  }

  // walls
  //

  walls::
  walls ()
  : ::xml_schema::type (),
    wall_ (::xml_schema::flags (), this)
  {
  }

  walls::
  walls (const walls& x,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    wall_ (x.wall_, f, this)
  {
  }

  walls::
  walls (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    wall_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void walls::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // wall
      //
      if (n.name () == "wall" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< wall_type > r (
          wall_traits::create (i, f, this));

        this->wall ().push_back (r);
        continue;
      }

      break;
    }
  }

  walls* walls::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new walls (*this, f, c);
  }

  // items
  //

  items::
  items ()
  : ::xml_schema::type (),
    item_ (::xml_schema::flags (), this)
  {
  }

  items::
  items (const items& x,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    item_ (x.item_, f, this)
  {
  }

  items::
  items (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    item_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void items::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // item
      //
      if (n.name () == "item" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< item_type > r (
          item_traits::create (i, f, this));

        this->item ().push_back (r);
        continue;
      }

      break;
    }
  }

  items* items::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new items (*this, f, c);
  }

  // northeast
  //

  northeast::
  northeast (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  northeast::
  northeast (const northeast& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  northeast::
  northeast (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void northeast::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  northeast* northeast::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new northeast (*this, f, c);
  }

  // southeast
  //

  southeast::
  southeast (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  southeast::
  southeast (const southeast& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  southeast::
  southeast (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void southeast::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  southeast* southeast::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new southeast (*this, f, c);
  }

  // northwest
  //

  northwest::
  northwest (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  northwest::
  northwest (const northwest& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  northwest::
  northwest (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void northwest::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  northwest* northwest::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new northwest (*this, f, c);
  }

  // southwest
  //

  southwest::
  southwest (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  southwest::
  southwest (const southwest& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  southwest::
  southwest (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void southwest::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  southwest* southwest::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new southwest (*this, f, c);
  }

  // eastnorth
  //

  eastnorth::
  eastnorth (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  eastnorth::
  eastnorth (const eastnorth& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  eastnorth::
  eastnorth (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void eastnorth::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  eastnorth* eastnorth::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new eastnorth (*this, f, c);
  }

  // eastsouth
  //

  eastsouth::
  eastsouth (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  eastsouth::
  eastsouth (const eastsouth& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  eastsouth::
  eastsouth (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void eastsouth::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  eastsouth* eastsouth::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new eastsouth (*this, f, c);
  }

  // westnorth
  //

  westnorth::
  westnorth (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  westnorth::
  westnorth (const westnorth& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  westnorth::
  westnorth (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void westnorth::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  westnorth* westnorth::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new westnorth (*this, f, c);
  }

  // westsouth
  //

  westsouth::
  westsouth (const x_type& x,
             const y_type& y)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this)
  {
  }

  westsouth::
  westsouth (const westsouth& x,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  westsouth::
  westsouth (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void westsouth::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }
  }

  westsouth* westsouth::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new westsouth (*this, f, c);
  }

  // bound_x
  //

  bound_x::
  bound_x (const minimum_type& minimum,
           const maximum_type& maximum)
  : ::xml_schema::type (),
    minimum_ (minimum, ::xml_schema::flags (), this),
    maximum_ (maximum, ::xml_schema::flags (), this)
  {
  }

  bound_x::
  bound_x (const bound_x& x,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    minimum_ (x.minimum_, f, this),
    maximum_ (x.maximum_, f, this)
  {
  }

  bound_x::
  bound_x (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    minimum_ (f, this),
    maximum_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void bound_x::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // minimum
      //
      if (n.name () == "minimum" && n.namespace_ ().empty ())
      {
        if (!minimum_.present ())
        {
          this->minimum (minimum_traits::create (i, f, this));
          continue;
        }
      }

      // maximum
      //
      if (n.name () == "maximum" && n.namespace_ ().empty ())
      {
        if (!maximum_.present ())
        {
          this->maximum (maximum_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!minimum_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "minimum",
        "");
    }

    if (!maximum_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "maximum",
        "");
    }
  }

  bound_x* bound_x::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new bound_x (*this, f, c);
  }

  // bound_y
  //

  bound_y::
  bound_y (const minimum_type& minimum,
           const maximum_type& maximum)
  : ::xml_schema::type (),
    minimum_ (minimum, ::xml_schema::flags (), this),
    maximum_ (maximum, ::xml_schema::flags (), this)
  {
  }

  bound_y::
  bound_y (const bound_y& x,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    minimum_ (x.minimum_, f, this),
    maximum_ (x.maximum_, f, this)
  {
  }

  bound_y::
  bound_y (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    minimum_ (f, this),
    maximum_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void bound_y::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // minimum
      //
      if (n.name () == "minimum" && n.namespace_ ().empty ())
      {
        if (!minimum_.present ())
        {
          this->minimum (minimum_traits::create (i, f, this));
          continue;
        }
      }

      // maximum
      //
      if (n.name () == "maximum" && n.namespace_ ().empty ())
      {
        if (!maximum_.present ())
        {
          this->maximum (maximum_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!minimum_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "minimum",
        "");
    }

    if (!maximum_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "maximum",
        "");
    }
  }

  bound_y* bound_y::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new bound_y (*this, f, c);
  }

  // tile
  //

  tile::
  tile (const x_type& x,
        const y_type& y,
        const offsetX_type& offsetX,
        const offsetY_type& offsetY,
        const bitmap_type& bitmap)
  : ::xml_schema::type (),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this),
    offsetX_ (offsetX, ::xml_schema::flags (), this),
    offsetY_ (offsetY, ::xml_schema::flags (), this),
    bitmap_ (bitmap, ::xml_schema::flags (), this)
  {
  }

  tile::
  tile (const tile& x,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this),
    offsetX_ (x.offsetX_, f, this),
    offsetY_ (x.offsetY_, f, this),
    bitmap_ (x.bitmap_, f, this)
  {
  }

  tile::
  tile (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    x_ (f, this),
    y_ (f, this),
    offsetX_ (f, this),
    offsetY_ (f, this),
    bitmap_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void tile::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // x
      //
      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        if (!x_.present ())
        {
          this->x (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        if (!y_.present ())
        {
          this->y (y_traits::create (i, f, this));
          continue;
        }
      }

      // offsetX
      //
      if (n.name () == "offsetX" && n.namespace_ ().empty ())
      {
        if (!offsetX_.present ())
        {
          this->offsetX (offsetX_traits::create (i, f, this));
          continue;
        }
      }

      // offsetY
      //
      if (n.name () == "offsetY" && n.namespace_ ().empty ())
      {
        if (!offsetY_.present ())
        {
          this->offsetY (offsetY_traits::create (i, f, this));
          continue;
        }
      }

      // bitmap
      //
      if (n.name () == "bitmap" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< bitmap_type > r (
          bitmap_traits::create (i, f, this));

        if (!bitmap_.present ())
        {
          this->bitmap (r);
          continue;
        }
      }

      break;
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "y",
        "");
    }

    if (!offsetX_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "offsetX",
        "");
    }

    if (!offsetY_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "offsetY",
        "");
    }

    if (!bitmap_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "bitmap",
        "");
    }
  }

  tile* tile::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new tile (*this, f, c);
  }

  // wall
  //

  wall::
  wall (const axis_type& axis,
        const index_type& index,
        const bitmap_type& bitmap)
  : ::xml_schema::type (),
    axis_ (axis, ::xml_schema::flags (), this),
    index_ (index, ::xml_schema::flags (), this),
    bitmap_ (bitmap, ::xml_schema::flags (), this)
  {
  }

  wall::
  wall (const wall& x,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    axis_ (x.axis_, f, this),
    index_ (x.index_, f, this),
    bitmap_ (x.bitmap_, f, this)
  {
  }

  wall::
  wall (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    axis_ (f, this),
    index_ (f, this),
    bitmap_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void wall::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // axis
      //
      if (n.name () == "axis" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< axis_type > r (
          axis_traits::create (i, f, this));

        if (!axis_.present ())
        {
          this->axis (r);
          continue;
        }
      }

      // index
      //
      if (n.name () == "index" && n.namespace_ ().empty ())
      {
        if (!index_.present ())
        {
          this->index (index_traits::create (i, f, this));
          continue;
        }
      }

      // bitmap
      //
      if (n.name () == "bitmap" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< bitmap_type > r (
          bitmap_traits::create (i, f, this));

        if (!bitmap_.present ())
        {
          this->bitmap (r);
          continue;
        }
      }

      break;
    }

    if (!axis_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "axis",
        "");
    }

    if (!index_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "index",
        "");
    }

    if (!bitmap_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "bitmap",
        "");
    }
  }

  wall* wall::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new wall (*this, f, c);
  }

  // item
  //

  item::
  item (const label_type& label,
        const direction_type& direction,
        const behavior_type& behavior,
        const type_type& type,
        const x_type& x,
        const y_type& y,
        const z_type& z)
  : ::xml_schema::type (),
    label_ (label, ::xml_schema::flags (), this),
    direction_ (direction, ::xml_schema::flags (), this),
    behavior_ (behavior, ::xml_schema::flags (), this),
    type_ (type, ::xml_schema::flags (), this),
    extra_ (::xml_schema::flags (), this),
    x_ (x, ::xml_schema::flags (), this),
    y_ (y, ::xml_schema::flags (), this),
    z_ (z, ::xml_schema::flags (), this)
  {
  }

  item::
  item (const item& x,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    label_ (x.label_, f, this),
    direction_ (x.direction_, f, this),
    behavior_ (x.behavior_, f, this),
    type_ (x.type_, f, this),
    extra_ (x.extra_, f, this),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this),
    z_ (x.z_, f, this)
  {
  }

  item::
  item (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    label_ (f, this),
    direction_ (f, this),
    behavior_ (f, this),
    type_ (f, this),
    extra_ (f, this),
    x_ (f, this),
    y_ (f, this),
    z_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void item::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // label
      //
      if (n.name () == "label" && n.namespace_ ().empty ())
      {
        if (!label_.present ())
        {
          this->label (label_traits::create (i, f, this));
          continue;
        }
      }

      // direction
      //
      if (n.name () == "direction" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< direction_type > r (
          direction_traits::create (i, f, this));

        if (!direction_.present ())
        {
          this->direction (r);
          continue;
        }
      }

      // behavior
      //
      if (n.name () == "behavior" && n.namespace_ ().empty ())
      {
        if (!behavior_.present ())
        {
          this->behavior (behavior_traits::create (i, f, this));
          continue;
        }
      }

      // type
      //
      if (n.name () == "type" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< type_type > r (
          type_traits::create (i, f, this));

        if (!type_.present ())
        {
          this->type (r);
          continue;
        }
      }

      // extra
      //
      if (n.name () == "extra" && n.namespace_ ().empty ())
      {
        this->extra ().push_back (extra_traits::create (i, f, this));
        continue;
      }

      break;
    }

    if (!label_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "label",
        "");
    }

    if (!direction_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "direction",
        "");
    }

    if (!behavior_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "behavior",
        "");
    }

    if (!type_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "type",
        "");
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "x" && n.namespace_ ().empty ())
      {
        this->x (x_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "y" && n.namespace_ ().empty ())
      {
        this->y (y_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "z" && n.namespace_ ().empty ())
      {
        this->z (z_traits::create (i, f, this));
        continue;
      }
    }

    if (!x_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "x",
        "");
    }

    if (!y_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "y",
        "");
    }

    if (!z_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "z",
        "");
    }
  }

  item* item::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new item (*this, f, c);
  }

  // axis
  //

  axis::
  axis (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_axis_convert ();
  }

  axis::
  axis (const ::xercesc::DOMAttr& a,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_axis_convert ();
  }

  axis::
  axis (const ::std::string& s,
        const ::xercesc::DOMElement* e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_axis_convert ();
  }

  axis* axis::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new axis (*this, f, c);
  }

  axis::value axis::
  _xsd_axis_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_axis_literals_);
    const value* i (::std::lower_bound (
                      _xsd_axis_indexes_,
                      _xsd_axis_indexes_ + 2,
                      *this,
                      c));

    if (i == _xsd_axis_indexes_ + 2 || _xsd_axis_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const axis::
  _xsd_axis_literals_[2] =
  {
    "x",
    "y"
  };

  const axis::value axis::
  _xsd_axis_indexes_[2] =
  {
    ::rxml::axis::x,
    ::rxml::axis::y
  };

  // direction
  //

  direction::
  direction (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_direction_convert ();
  }

  direction::
  direction (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_direction_convert ();
  }

  direction::
  direction (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f,
             ::xml_schema::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_direction_convert ();
  }

  direction* direction::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new direction (*this, f, c);
  }

  direction::value direction::
  _xsd_direction_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_direction_literals_);
    const value* i (::std::lower_bound (
                      _xsd_direction_indexes_,
                      _xsd_direction_indexes_ + 13,
                      *this,
                      c));

    if (i == _xsd_direction_indexes_ + 13 || _xsd_direction_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const direction::
  _xsd_direction_literals_[13] =
  {
    "none",
    "south",
    "west",
    "north",
    "east",
    "northeast",
    "southeast",
    "southwest",
    "northwest",
    "eastnorth",
    "eastsouth",
    "westnorth",
    "westsouth"
  };

  const direction::value direction::
  _xsd_direction_indexes_[13] =
  {
    ::rxml::direction::east,
    ::rxml::direction::eastnorth,
    ::rxml::direction::eastsouth,
    ::rxml::direction::none,
    ::rxml::direction::north,
    ::rxml::direction::northeast,
    ::rxml::direction::northwest,
    ::rxml::direction::south,
    ::rxml::direction::southeast,
    ::rxml::direction::southwest,
    ::rxml::direction::west,
    ::rxml::direction::westnorth,
    ::rxml::direction::westsouth
  };

  // type
  //

  type::
  type (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_type_convert ();
  }

  type::
  type (const ::xercesc::DOMAttr& a,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_type_convert ();
  }

  type::
  type (const ::std::string& s,
        const ::xercesc::DOMElement* e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_type_convert ();
  }

  type* type::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new type (*this, f, c);
  }

  type::value type::
  _xsd_type_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_type_literals_);
    const value* i (::std::lower_bound (
                      _xsd_type_indexes_,
                      _xsd_type_indexes_ + 4,
                      *this,
                      c));

    if (i == _xsd_type_indexes_ + 4 || _xsd_type_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const type::
  _xsd_type_literals_[4] =
  {
    "wall",
    "door",
    "griditem",
    "freeitem"
  };

  const type::value type::
  _xsd_type_indexes_[4] =
  {
    ::rxml::type::door,
    ::rxml::type::freeitem,
    ::rxml::type::griditem,
    ::rxml::type::wall
  };
}

#include <istream>
#include <xercesc/framework/Wrapper4InputSource.hpp>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace rxml
{
  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::std::string& u,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    ::std::auto_ptr< ::rxml::RoomXML > r (
      ::rxml::room (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::std::string& u,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::rxml::RoomXML > r (
      ::rxml::room (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::std::string& u,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::rxml::RoomXML > r (
      ::rxml::room (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::rxml::room (wrap, f, p);
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::rxml::room (wrap, h, f, p);
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::rxml::room (wrap, h, f, p);
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        const ::std::string& sid,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::rxml::room (wrap, f, p);
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        const ::std::string& sid,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::rxml::room (wrap, h, f, p);
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::std::istream& is,
        const ::std::string& sid,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::rxml::room (wrap, h, f, p);
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMInputSource& i,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    ::std::auto_ptr< ::rxml::RoomXML > r (
      ::rxml::room (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMInputSource& i,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::rxml::RoomXML > r (
      ::rxml::room (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMInputSource& i,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::rxml::RoomXML > r (
      ::rxml::room (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (const ::xercesc::DOMDocument& d,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
        static_cast< ::xercesc::DOMDocument* > (d.cloneNode (true)));

      ::std::auto_ptr< ::rxml::RoomXML > r (
        ::rxml::room (
          c.get (), f | ::xml_schema::flags::own_dom, p));

      c.release ();
      return r;
    }

    const ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "room" &&
        n.namespace_ () == "")
    {
      ::std::auto_ptr< ::rxml::RoomXML > r (
        ::xsd::cxx::tree::traits< ::rxml::RoomXML, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "room",
      "");
  }

  ::std::auto_ptr< ::rxml::RoomXML >
  room (::xercesc::DOMDocument* d,
        ::xml_schema::flags f,
        const ::xml_schema::properties&)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    const ::xercesc::DOMElement& e (
      c.get ()
      ? *c->getDocumentElement ()
      : *d->getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "room" &&
        n.namespace_ () == "")
    {
      ::std::auto_ptr< ::rxml::RoomXML > r (
        ::xsd::cxx::tree::traits< ::rxml::RoomXML, char >::create (
          e, f, 0));
      c.release ();
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "room",
      "");
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

