// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef ITEMS_XML_HPP
#define ITEMS_XML_HPP

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 3000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/tree/parsing.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type<type> simple_type;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef integer non_positive_integer;
  typedef integer non_negative_integer;
  typedef integer positive_integer;
  typedef integer negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::day< char, simple_type > day;
  typedef ::xsd::cxx::tree::month< char, simple_type > month;
  typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
  typedef ::xsd::cxx::tree::year< char, simple_type > year;
  typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // DOM user data key for back pointers to tree nodes.
  //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA

  const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::serialization< char > serialization;
  typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
  typedef ::xsd::cxx::tree::bounds< char > bounds;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Error handler interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;
}

// Forward declarations.
//
namespace ixml
{
  class ItemsXML;
  class item;
  class door;
  class bitmap;
  class shadow;
}


#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

namespace ixml
{
  class ItemsXML: public ::xml_schema::type
  {
    public:
    // item
    // 
    typedef ::ixml::item item_type;
    typedef ::xsd::cxx::tree::sequence< item_type > item_sequence;
    typedef item_sequence::iterator item_iterator;
    typedef item_sequence::const_iterator item_const_iterator;
    typedef ::xsd::cxx::tree::traits< item_type, char > item_traits;

    const item_sequence&
    item () const;

    item_sequence&
    item ();

    void
    item (const item_sequence& s);

    // Constructors.
    //
    ItemsXML ();

    ItemsXML (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::type* c = 0);

    ItemsXML (const ItemsXML& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::type* c = 0);

    virtual ItemsXML*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    item_sequence item_;
  };

  class item: public ::xml_schema::type
  {
    public:
    // door
    // 
    typedef ::ixml::door door_type;
    typedef ::xsd::cxx::tree::optional< door_type > door_optional;
    typedef ::xsd::cxx::tree::traits< door_type, char > door_traits;

    const door_optional&
    door () const;

    door_optional&
    door ();

    void
    door (const door_type& x);

    void
    door (const door_optional& x);

    void
    door (::std::auto_ptr< door_type > p);

    // widthX
    // 
    typedef ::xml_schema::int_ widthX_type;
    typedef ::xsd::cxx::tree::sequence< widthX_type > widthX_sequence;
    typedef widthX_sequence::iterator widthX_iterator;
    typedef widthX_sequence::const_iterator widthX_const_iterator;
    typedef ::xsd::cxx::tree::traits< widthX_type, char > widthX_traits;

    const widthX_sequence&
    widthX () const;

    widthX_sequence&
    widthX ();

    void
    widthX (const widthX_sequence& s);

    // widthY
    // 
    typedef ::xml_schema::int_ widthY_type;
    typedef ::xsd::cxx::tree::sequence< widthY_type > widthY_sequence;
    typedef widthY_sequence::iterator widthY_iterator;
    typedef widthY_sequence::const_iterator widthY_const_iterator;
    typedef ::xsd::cxx::tree::traits< widthY_type, char > widthY_traits;

    const widthY_sequence&
    widthY () const;

    widthY_sequence&
    widthY ();

    void
    widthY (const widthY_sequence& s);

    // height
    // 
    typedef ::xml_schema::int_ height_type;
    typedef ::xsd::cxx::tree::sequence< height_type > height_sequence;
    typedef height_sequence::iterator height_iterator;
    typedef height_sequence::const_iterator height_const_iterator;
    typedef ::xsd::cxx::tree::traits< height_type, char > height_traits;

    const height_sequence&
    height () const;

    height_sequence&
    height ();

    void
    height (const height_sequence& s);

    // directionFrames
    // 
    typedef ::xml_schema::byte directionFrames_type;
    typedef ::xsd::cxx::tree::traits< directionFrames_type, char > directionFrames_traits;

    const directionFrames_type&
    directionFrames () const;

    directionFrames_type&
    directionFrames ();

    void
    directionFrames (const directionFrames_type& x);

    // mortal
    // 
    typedef ::xml_schema::boolean mortal_type;
    typedef ::xsd::cxx::tree::traits< mortal_type, char > mortal_traits;

    const mortal_type&
    mortal () const;

    mortal_type&
    mortal ();

    void
    mortal (const mortal_type& x);

    // weight
    // 
    typedef ::xml_schema::double_ weight_type;
    typedef ::xsd::cxx::tree::traits< weight_type, char > weight_traits;

    const weight_type&
    weight () const;

    weight_type&
    weight ();

    void
    weight (const weight_type& x);

    // framesDelay
    // 
    typedef ::xml_schema::double_ framesDelay_type;
    typedef ::xsd::cxx::tree::traits< framesDelay_type, char > framesDelay_traits;

    const framesDelay_type&
    framesDelay () const;

    framesDelay_type&
    framesDelay ();

    void
    framesDelay (const framesDelay_type& x);

    // speed
    // 
    typedef ::xml_schema::double_ speed_type;
    typedef ::xsd::cxx::tree::traits< speed_type, char > speed_traits;

    const speed_type&
    speed () const;

    speed_type&
    speed ();

    void
    speed (const speed_type& x);

    // bitmap
    // 
    typedef ::ixml::bitmap bitmap_type;
    typedef ::xsd::cxx::tree::traits< bitmap_type, char > bitmap_traits;

    const bitmap_type&
    bitmap () const;

    bitmap_type&
    bitmap ();

    void
    bitmap (const bitmap_type& x);

    void
    bitmap (::std::auto_ptr< bitmap_type > p);

    // shadow
    // 
    typedef ::ixml::shadow shadow_type;
    typedef ::xsd::cxx::tree::optional< shadow_type > shadow_optional;
    typedef ::xsd::cxx::tree::traits< shadow_type, char > shadow_traits;

    const shadow_optional&
    shadow () const;

    shadow_optional&
    shadow ();

    void
    shadow (const shadow_type& x);

    void
    shadow (const shadow_optional& x);

    void
    shadow (::std::auto_ptr< shadow_type > p);

    // extraFrames
    // 
    typedef ::xml_schema::int_ extraFrames_type;
    typedef ::xsd::cxx::tree::optional< extraFrames_type > extraFrames_optional;
    typedef ::xsd::cxx::tree::traits< extraFrames_type, char > extraFrames_traits;

    const extraFrames_optional&
    extraFrames () const;

    extraFrames_optional&
    extraFrames ();

    void
    extraFrames (const extraFrames_type& x);

    void
    extraFrames (const extraFrames_optional& x);

    // frame
    // 
    typedef ::xml_schema::int_ frame_type;
    typedef ::xsd::cxx::tree::sequence< frame_type > frame_sequence;
    typedef frame_sequence::iterator frame_iterator;
    typedef frame_sequence::const_iterator frame_const_iterator;
    typedef ::xsd::cxx::tree::traits< frame_type, char > frame_traits;

    const frame_sequence&
    frame () const;

    frame_sequence&
    frame ();

    void
    frame (const frame_sequence& s);

    // label
    // 
    typedef ::xml_schema::short_ label_type;
    typedef ::xsd::cxx::tree::traits< label_type, char > label_traits;

    const label_type&
    label () const;

    label_type&
    label ();

    void
    label (const label_type& x);

    // Constructors.
    //
    item (const directionFrames_type&,
          const mortal_type&,
          const weight_type&,
          const framesDelay_type&,
          const speed_type&,
          const bitmap_type&,
          const label_type&);

    item (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    item (const item& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual item*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    door_optional door_;
    widthX_sequence widthX_;
    widthY_sequence widthY_;
    height_sequence height_;
    ::xsd::cxx::tree::one< directionFrames_type > directionFrames_;
    ::xsd::cxx::tree::one< mortal_type > mortal_;
    ::xsd::cxx::tree::one< weight_type > weight_;
    ::xsd::cxx::tree::one< framesDelay_type > framesDelay_;
    ::xsd::cxx::tree::one< speed_type > speed_;
    ::xsd::cxx::tree::one< bitmap_type > bitmap_;
    shadow_optional shadow_;
    extraFrames_optional extraFrames_;
    frame_sequence frame_;
    ::xsd::cxx::tree::one< label_type > label_;
  };

  class door: public ::xml_schema::string
  {
    public:
    enum value
    {
      north,
      south,
      east,
      west
    };

    door (value v);

    door (const ::xml_schema::string& v);

    door (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    door (const ::xercesc::DOMAttr& a,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    door (const ::std::string& s,
          const ::xercesc::DOMElement* e,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    door (const door& x,
          ::xml_schema::flags f = 0,
          ::xml_schema::type* c = 0);

    virtual door*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    door&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_door_convert ();
    }

    protected:
    value
    _xsd_door_convert () const;

    public:
    static const char* const _xsd_door_literals_[4];
    static const value _xsd_door_indexes_[4];
  };

  class bitmap: public ::xml_schema::type
  {
    public:
    // frameWidth
    // 
    typedef ::xml_schema::int_ frameWidth_type;
    typedef ::xsd::cxx::tree::traits< frameWidth_type, char > frameWidth_traits;

    const frameWidth_type&
    frameWidth () const;

    frameWidth_type&
    frameWidth ();

    void
    frameWidth (const frameWidth_type& x);

    // frameHeight
    // 
    typedef ::xml_schema::int_ frameHeight_type;
    typedef ::xsd::cxx::tree::traits< frameHeight_type, char > frameHeight_traits;

    const frameHeight_type&
    frameHeight () const;

    frameHeight_type&
    frameHeight ();

    void
    frameHeight (const frameHeight_type& x);

    // file
    // 
    typedef ::xml_schema::string file_type;
    typedef ::xsd::cxx::tree::traits< file_type, char > file_traits;

    const file_type&
    file () const;

    file_type&
    file ();

    void
    file (const file_type& x);

    void
    file (::std::auto_ptr< file_type > p);

    // Constructors.
    //
    bitmap (const frameWidth_type&,
            const frameHeight_type&,
            const file_type&);

    bitmap (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0);

    bitmap (const bitmap& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0);

    virtual bitmap*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< frameWidth_type > frameWidth_;
    ::xsd::cxx::tree::one< frameHeight_type > frameHeight_;
    ::xsd::cxx::tree::one< file_type > file_;
  };

  class shadow: public ::xml_schema::type
  {
    public:
    // shadowWidth
    // 
    typedef ::xml_schema::int_ shadowWidth_type;
    typedef ::xsd::cxx::tree::traits< shadowWidth_type, char > shadowWidth_traits;

    const shadowWidth_type&
    shadowWidth () const;

    shadowWidth_type&
    shadowWidth ();

    void
    shadowWidth (const shadowWidth_type& x);

    // shadowHeight
    // 
    typedef ::xml_schema::int_ shadowHeight_type;
    typedef ::xsd::cxx::tree::traits< shadowHeight_type, char > shadowHeight_traits;

    const shadowHeight_type&
    shadowHeight () const;

    shadowHeight_type&
    shadowHeight ();

    void
    shadowHeight (const shadowHeight_type& x);

    // file
    // 
    typedef ::xml_schema::string file_type;
    typedef ::xsd::cxx::tree::traits< file_type, char > file_traits;

    const file_type&
    file () const;

    file_type&
    file ();

    void
    file (const file_type& x);

    void
    file (::std::auto_ptr< file_type > p);

    // Constructors.
    //
    shadow (const shadowWidth_type&,
            const shadowHeight_type&,
            const file_type&);

    shadow (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0);

    shadow (const shadow& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0);

    virtual shadow*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::type* c = 0) const;

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    private:
    ::xsd::cxx::tree::one< shadowWidth_type > shadowWidth_;
    ::xsd::cxx::tree::one< shadowHeight_type > shadowHeight_;
    ::xsd::cxx::tree::one< file_type > file_;
  };
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace ixml
{
  // Parse a URI or a local file.
  //

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::std::string& uri,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::std::string& uri,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::std::string& uri,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::std::istream& is,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::std::istream& is,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::std::istream& is,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::std::istream& is,
         const ::std::string& id,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::std::istream& is,
         const ::std::string& id,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::std::istream& is,
         const ::std::string& id,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMInputSource.
  //

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::xercesc::DOMInputSource& is,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::xercesc::DOMInputSource& is,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::xercesc::DOMInputSource& is,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (const ::xercesc::DOMDocument& d,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::auto_ptr< ::ixml::ItemsXML >
  items (::xercesc::DOMDocument* d,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // ITEMS_XML_HPP
