#!/usr/bin/python2.5
from operator import itemgetter

class hangmanSolver():
	def __init__(self, dictionaryFile="", mask="", iChars=""):
		if dictionaryFile != "":
			self.setDictionary(dictionaryFile)
		else:
			self.dictionary = []
		self.setMask(mask)
		self.setIChars(iChars)
	
	def setMask(self, mask):
		"""Sets the mask for the puzzle (passed in as string, with - for unknown letters)"""
		self.mask = list(mask)
	
	def setIChars(self, iChars):
		"""Sets used chars. Removes all commas and spaces first."""
		iChars = iChars.replace(" ", "").replace(",", "")
		self.iChars = list(iChars)
	
	def setDictionary(self, fileName):
		self.dictionary = getList(fileName)
	
	def getPossibleSolutions(self):
		"""Returns list of possible solutions."""
		return self.result
	
	def getLetterRecommendations(self):
		"""Returns sorted list of letter recomendations, with popularity of each."""
		lettersLeft = getletterOccurrences(self.result, getlettersLeft(self.mask, self.iChars))
		return revSortDict(lettersLeft)
	
	def solve(self):
		"""Solves puzzle, and stores result."""
		self.result = getListWithAll(self.dictionary, self.mask, self.iChars)

def strContainsAny(str, set):
	for c in set:
		if c in str: return 1;
	return 0;

def strContainsAll(string, set, iChars):
	"""Checks whether string contains all of the chars in set (in correct positions), and does not contain any iChars"""
	if len(string) != len(set): return 0;
	if strContainsAny(string, iChars): return 0;
	for index, c in enumerate(set):
		if c != "-":
			if c != string[index]: return 0;
		else:
			if string[index] in set: return 0;
	return 1;

def getListWithAll(wordlist, set, iChars):
	"""Returns list of all words containing 'set' of characters, and not containing any 'iChars'"""
	result = []
	for line in wordlist:
		if strContainsAll(line, set, iChars): result.append(line);
	return result

def getList(file):
	"""Returns list with each line of input file as list item"""
	dictionaryFile = open(file, "r")
	dictionary = dictionaryFile.readlines()
	dictionaryFile.close()
	# Remove \r\n from input (probably a better way to do this though)
	for index, line in enumerate(dictionary):
        	dictionary[index] = dictionary[index].strip()
	return dictionary

def getlettersLeft(mask, iChars):
	"""Returns letters that haven't been guessed yet."""
	alphabet = list("abcdefghijklmnopqrstuvwxyz")
	for index, letter in enumerate(alphabet):
		if letter in mask or letter in iChars:
			alphabet.remove(letter)
	return alphabet

def getwordsCharIn(words, letter):
	"""Returns number of words character is in from input list"""
	number = 0
	for word in words:
		if letter in word: number+=1;
	return number

def getletterOccurrences(words, alphabet):
	"""Returns dictionary containing letters of alphabet, and number of words each character is in"""
	occurrences = {}
	for letter in alphabet:
		wordsCharIn = getwordsCharIn(words, letter)
		if wordsCharIn != 0:
			occurrences[letter] = wordsCharIn
	return occurrences

def revSortDict(dictionaryIn):
	"""Sorts a dictionary input """
	return sorted(dictionaryIn.items(), key=itemgetter(1), reverse=True)

def removeZeros(dictionaryIn):
	"""Removes all dictionary items with a value of zero"""
	for item in dictionaryIn.keys():
		if dictionaryIn[item] == 0:
			del dictionaryIn[item]
	return dictionaryIn

def addStrToList(listA, listB):
	"""Adds the letters from listA that are not in listB to listB, ignoring dashes"""
	for letter in listA:
		if letter != "-":
			if letter not in listB:
				listB.append(letter)
	return listB

#dictionaryFile = "wordlist.txt"
#mask = list(raw_input("Please enter the puzzle word using dashes (-) to indicate unknown letters. Example: n-ght: "))
#incorrectChars = list(raw_input("Please enter all letters you have guessed, and are wrong (no spaces): "))
#dictionary = getList(dictionaryFile)
#result = getListWithAll(dictionary, mask, incorrectChars)
#print result

# What to guess next!
#lettersLeft = getletterOccurrences(result, getlettersLeft(mask, incorrectChars))
#lettersLeft = revSortDict(lettersLeft)
#print lettersLeft
#print "You should guess: " + lettersLeft[0][0]
