#include "main.h"

void create_window()
{
	index_src_lang = settings_int_get("default", "src_lang", 0);
	index_tar_lang = settings_int_get("default", "tar_lang", 0);
	
	program = hildon_program_get_instance();
	window = hildon_window_new();
	gtk_container_set_border_width(GTK_CONTAINER(window), 6);
	hildon_program_add_window(program, HILDON_WINDOW(window));
	g_signal_connect(G_OBJECT(window), "delete_event", G_CALLBACK(gtk_main_quit), NULL);
	
	/* TARGET AND SOURCE LANGUAGE BUTTONS AND SWAP BUTTON */
	hbox_top = gtk_hbox_new(FALSE, 0);
	
	button_src_lang = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Source Language", languages[index_src_lang].str_long);
	g_signal_connect(G_OBJECT(button_src_lang), "clicked", G_CALLBACK(change_language), (gpointer)1);
	
	gchar* swap_file = g_strdup_printf(DATAPREFIX"/swap.png");
	button_swap = hildon_button_new(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_image(HILDON_BUTTON(button_swap), gtk_image_new_from_file(swap_file));
	g_free(swap_file);
	g_signal_connect(G_OBJECT(button_swap), "clicked", G_CALLBACK(swap_languages), NULL);
										
	button_tar_lang = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Target Language", languages[index_tar_lang].str_long);
	g_signal_connect(G_OBJECT(button_tar_lang), "clicked", G_CALLBACK(change_language), (gpointer)2);
	
	hildon_button_set_image(HILDON_BUTTON(button_src_lang), gtk_image_new_from_pixbuf(flags[index_src_lang]));
	hildon_button_set_image(HILDON_BUTTON(button_tar_lang), gtk_image_new_from_pixbuf(flags[index_tar_lang]));
	
	if (index_src_lang == 0)
	{
		gtk_widget_set_sensitive(button_swap, FALSE);
	}
	else
	{
		gtk_widget_set_sensitive(button_swap, TRUE);
	}

	gtk_box_pack_start(GTK_BOX(hbox_top), button_src_lang, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_top), button_swap,     TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_top), button_tar_lang, TRUE, TRUE, 0);
	
	/* TEXTFIELDS */
	hbox_center = gtk_hbox_new(TRUE, 0);
	
	textview_source = hildon_text_view_new();
	textview_target = hildon_text_view_new();
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview_source), GTK_WRAP_WORD);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview_target), GTK_WRAP_WORD);
	
	buffer_source     = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview_source));
	buffer_translated = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview_target));
	
	GtkWidget* scroll_source = hildon_pannable_area_new();
	GtkWidget* scroll_target = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(scroll_source), textview_source);
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(scroll_target), textview_target);
	
	gtk_box_pack_start(GTK_BOX(hbox_center), scroll_source, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_center), scroll_target, TRUE, TRUE, 0);
	
	/* PASTE, TRANSLATE AND COPY BUTTONS */
	hbox_bottom = gtk_hbox_new(FALSE, 0);
	
	button_paste = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Paste", NULL);
	g_signal_connect(G_OBJECT(button_paste), "clicked", G_CALLBACK(paste_text), NULL);
							
	button_translate = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Translate", NULL);
	g_signal_connect(G_OBJECT(button_translate), "clicked", G_CALLBACK(translate), NULL);
							
	button_copy = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Copy", NULL);			
	g_signal_connect(G_OBJECT(button_copy), "clicked", G_CALLBACK(copy_text), NULL);
	
	button_clear1 = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Clear", NULL);
	button_clear2 = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Clear", NULL);
	g_signal_connect(G_OBJECT(button_clear1), "clicked", G_CALLBACK(clear_text), (gpointer)1);
	g_signal_connect(G_OBJECT(button_clear2), "clicked", G_CALLBACK(clear_text), (gpointer)2);
	
	button_say1 = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Say", NULL);
	button_say2 = hildon_button_new_with_text(HILDON_SIZE_AUTO | HILDON_SIZE_FINGER_HEIGHT,
							HILDON_BUTTON_ARRANGEMENT_VERTICAL,
							"Say", NULL);
	g_signal_connect(G_OBJECT(button_say1), "clicked", G_CALLBACK(say_text), (gpointer)1);
	g_signal_connect(G_OBJECT(button_say2), "clicked", G_CALLBACK(say_text), (gpointer)2);
	
	/*if (index_src_lang == 0)
	{
		gtk_widget_set_sensitive(button_say1, FALSE);
	}
	else
	{
		gtk_widget_set_sensitive(button_say1, TRUE);
	}*/
	
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_paste,     TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_clear1,    TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_say1,      TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_translate, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_say2,      TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_clear2,    TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_bottom), button_copy,      TRUE, TRUE, 0);
	
	/* Add hboxes to main vbox */
	
	vbox_main = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_main), hbox_top,    FALSE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_main), hbox_center, TRUE,  TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_main), hbox_bottom, FALSE, TRUE, 0);
	
	gtk_container_add(GTK_CONTAINER(window), vbox_main);
	
	gtk_widget_show_all(GTK_WIDGET(window));
	
	/* Create a menu */
	HildonAppMenu* menu = HILDON_APP_MENU(hildon_app_menu_new());
	
	GtkWidget* button = hildon_gtk_button_new(HILDON_SIZE_AUTO);
	gtk_button_set_label(GTK_BUTTON(button), "About");
	g_signal_connect_after(G_OBJECT(button), "clicked", G_CALLBACK(show_about), NULL);
	hildon_app_menu_append(menu, GTK_BUTTON(button));
	
	gtk_widget_show_all(GTK_WIDGET(menu));
	
	hildon_window_set_app_menu(HILDON_WINDOW(window), menu);
	
	/* eSpeak check availtable languages */
	
	espeak_Initialize(AUDIO_OUTPUT_RETRIEVAL, 0, NULL,0);
	
	int m;
	for (m = 0; m < 52; m++)
	{
		espeak_VOICE voice;
		voice.languages = languages[m].str_short;
		voice.age = 0;
		voice.gender = 0;
		voice.name = NULL;
		
		if (espeak_SetVoiceByProperties(&voice) == EE_OK)
		{
			languages[m].espeak = TRUE;
		}
	}
	
	espeak_Terminate();
	
	gtk_widget_set_sensitive(button_say1, languages[index_src_lang].espeak);
	gtk_widget_set_sensitive(button_say2, languages[index_tar_lang].espeak);
}
