#include "main.h"

GKeyFile* settings = NULL;

void settings_init()
{
	settings = g_key_file_new();
	
	gchar* file = g_strdup_printf("%s/gTranslate.conf", g_get_user_config_dir());
	g_key_file_load_from_file(settings, file, G_KEY_FILE_KEEP_COMMENTS, NULL);
	g_debug("%s\n", file);
	g_free(file);
}

void settings_free()
{
	gchar* data = g_key_file_to_data(settings, NULL, NULL);
	gchar* file = g_strdup_printf("%s/gTranslate.conf", g_get_user_config_dir());
	
	g_file_set_contents(file, data, -1, NULL);
	
	g_free(data);
	g_free(file);
	g_key_file_free(settings);
}

void settings_int_set(gchar* group, gchar* key, gint value)
{
	g_key_file_set_integer(settings, group, key, value);
}

gint settings_int_get(gchar* group, gchar* key, gint default_value)
{
	GError* error = NULL;
	gint result = g_key_file_get_integer(settings, group, key, &error);
	
	if (error)
	{
		g_error_free(error);
		g_key_file_set_integer(settings, group, key, default_value);
		return default_value;
	}
	
	return result;
}
