//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef SENDWINDOW_H
#define SENDWINDOW_H

#include <QDialog>
#ifdef Q_WS_MAEMO_5
    #define MODEST_DBUS_NAME    "modest"
    #define MODEST_DBUS_SERVICE "com.nokia."MODEST_DBUS_NAME
    #define MODEST_DBUS_OBJECT  "/com/nokia/"MODEST_DBUS_NAME /* Also known as a D-Bus Path. */
    #define MODEST_DBUS_IFACE   "com.nokia."MODEST_DBUS_NAME
    #define MODEST_DBUS_METHOD_MAIL_TO "MailTo"
#endif
#include "contact.h"

namespace Ui {
    class SendWindow;
}

class SendWindow : public QDialog
{
    Q_OBJECT

public:
    explicit SendWindow(QWidget *parent, QList<Contact*>* contacts);
    ~SendWindow();

private:    
    Ui::SendWindow *ui;
    QList<Contact*>* m_Contacts;

    void SetLabels();

private slots:
    void SendSlot();
    void SendEmailSlot();
    void SendIMSlot();
};

#endif // SENDWINDOW_H
