//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "sendwindow.h"
#include "ui_sendwindow.h"
#include <QUrl>
#ifdef Q_WS_MAEMO_5
#include "hildon-uri.h"
#include <QDBusInterface>
#include <QMessageService>
#include <QMessage>
using namespace QtMobility;
#endif
#include "contact.h"
#include "commonstatic.h"

SendWindow::SendWindow(QWidget *parent, QList<Contact*>* contacts) :
    QDialog(parent),
    ui(new Ui::SendWindow)
{
    ui->setupUi(this);

    m_Contacts = contacts;

    connect(ui->btnSMS, SIGNAL(clicked()), this, SLOT(SendSlot()));
    connect(ui->btnEmail, SIGNAL(clicked()), this, SLOT(SendEmailSlot()));
    //connect(ui->btnIM, SIGNAL(clicked()), this, SLOT(SendIMSlot()));

    SetLabels();
}

SendWindow::~SendWindow()
{
    delete ui;
}


void SendWindow::SendSlot()
{
    QList<QString> toSend;
    foreach (Contact* c, *m_Contacts)
        toSend.append(c->Number);

    if (toSend.count() > 0){
#ifdef Q_WS_MAEMO_5
            QString strTo;
            foreach (QString n, toSend){
                if (!strTo.isEmpty())
                    strTo.append(", ");
                strTo.append(n);
            }

            QUrl smsUrl((QString("sms:%1").arg(strTo)));
            smsUrl.addQueryItem("body", "");
            hildon_uri_open(smsUrl.toString().toStdString().c_str(),NULL,NULL);
#endif
    }
    accept();
}

void SendWindow::SendEmailSlot()
{
    QList<QString> toSend;
    foreach (Contact* c, *m_Contacts){
        if (c && c->eMails){
            foreach (QString email, *c->eMails){
                if (!toSend.contains(email))
                    toSend.append(email);
            }
        }
    }

    if (toSend.count() > 0){
#ifdef Q_WS_MAEMO_5
            QString strTo;
            foreach (QString n, toSend){
                if (!strTo.isEmpty())
                    strTo.append("%2C%20");
                strTo.append(n);
            }

            QUrl emailUrl((QString("mailto:%1").arg(strTo)));
            emailUrl.addQueryItem("subject", "");
            emailUrl.addQueryItem("body", "");

            QDBusInterface dbusif(MODEST_DBUS_SERVICE, MODEST_DBUS_OBJECT, MODEST_DBUS_IFACE);
            QDBusMessage msg = dbusif.call(MODEST_DBUS_METHOD_MAIL_TO, emailUrl.toString());
#endif
        //}
    }
    accept();
}

void SendWindow::SendIMSlot()
{
#ifdef Q_WS_MAEMO_5
    QMessage message;
    QMessageService service;

    message.setType(QMessage::InstantMessage);

    service.send(message);
#endif
    accept();
}

void SendWindow::SetLabels()
{
    int n = 0;
    int e = 0;
    //int i = 0;
    foreach (Contact* c, *m_Contacts){
        if (c && c->eMails && c->eMails->count())
            e++;
        n++;
    }

    ui->btnEmail->setEnabled(e > 0);

    ui->btnSMS->setText(QString("%1").arg(n));
    ui->btnEmail->setText(QString("%1").arg(e));
    //ui->btnIM->setText(QString("%1").arg(i));
}
