//    Group SMS
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef COMMONSTATIC_H
#define COMMONSTATIC_H
#include <QWidget>
#include <QString>
#include <QMessageBox>
#include "contact.h"

#define QUOTE_(x) #x
#define QUOTE(x) QUOTE_(x)

class CommonStatic
{
public:
    static QList<Contact*> ContactsCache;
    static void LoadContactsCache();
    static Contact* GetContact(int id);

    static QMessageBox::StandardButton ConfirmMessage(QWidget* parent, QString title, QString message);
    static void ErrorMessage(QWidget* parent, QString message);
    static void InfoMessage(QWidget* parent, QString message);

    static QString GetHomeFolder();
    static QString GetSettingsFolder();

    static bool IsMouseOver(QWidget* w);
};

#endif // COMMONSTATIC_H
