/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CUSTOM_RATING_RENDERER_H
#define CUSTOM_RATING_RENDERER_H

#include <gtk/gtk.h>

/* Some boilerplate GObject type check and type cast macros.
 *  'klass' is used here instead of 'class', because 'class'
 *  is a c++ keyword */

#define CUSTOM_TYPE_CELL_RENDERER_RATING             (custom_cell_renderer_rating_get_type())
#define CUSTOM_CELL_RENDERER_RATING(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj),  CUSTOM_TYPE_CELL_RENDERER_RATING, CustomCellRendererRating))
#define CUSTOM_CELL_RENDERER_RATING_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass),  CUSTOM_TYPE_CELL_RENDERER_RATING, CustomCellRendererRatingClass))
#define CUSTOM_IS_CELL_RATING_RATING(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CUSTOM_TYPE_CELL_RENDERER_RATING))
#define CUSTOM_IS_CELL_RATING_RATING_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass),  CUSTOM_TYPE_CELL_RENDERER_RATING))
#define CUSTOM_CELL_RENDERER_RATING_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj),  CUSTOM_TYPE_CELL_RENDERER_RATING, CustomCellRendererRatingClass))

typedef struct _CustomCellRendererRating CustomCellRendererRating;
typedef struct _CustomCellRendererRatingClass CustomCellRendererRatingClass;

/* CustomCellRendererRating: Our custom cell renderer
 *   structure. Extend according to need */

struct _CustomCellRendererRating
{
  GtkCellRenderer   parent;
  gint              difficulty, terrain;
};


struct _CustomCellRendererRatingClass
{
  GtkCellRendererClass  parent_class;
};


GType                custom_cell_renderer_rating_get_type (void);

GtkCellRenderer     *custom_cell_renderer_rating_new (void);


#endif /* CUSTOM_RATING_RENDERER_H */
