#ifndef ROMDELEGATE_H
#define ROMDELEGATE_H

#include <QStyledItemDelegate>
#include <QPainter>
#include <QMaemo5Style>
#include <QFontMetrics>

class RomDelegate : public QStyledItemDelegate
{
    Q_OBJECT

public:
    RomDelegate(QObject *parent) : QStyledItemDelegate(parent) { }

    void paint (QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
    {
        QStyledItemDelegate::paint(painter, option, QModelIndex());

        QFileInfo info = index.data(Qt::StatusTipRole).toString();
        QIcon icon = qvariant_cast<QIcon>(index.data(Qt::DecorationRole));

        QRect r = option.rect;
        QFont f = painter->font();
        QColor secondaryColor = QMaemo5Style::standardColor("SecondaryTextColor");

        painter->save();

        r.adjust(3, 3, -3, -3);

        int iconSize = r.height();

        painter->drawPixmap(r.left(), r.top(), iconSize, iconSize,
                            (icon.isNull() ? QIcon(":/gba.png") : icon).pixmap(iconSize, iconSize));

        r.adjust(iconSize + 6, 3, 0, -9);

        f.setPointSize(18);
        painter->setFont(f);
        painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignTop|Qt::AlignLeft,
                          QFontMetrics(f).elidedText(info.completeBaseName(), Qt::ElideRight, r.width()));

        f.setPointSize(13);
        painter->setFont(f);
        painter->setPen(QPen(secondaryColor));
        painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignBottom|Qt::AlignLeft,
                          QFontMetrics(f).elidedText(info.suffix(), Qt::ElideRight, r.width()));

        painter->restore();
    }

    QSize sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const
    {
        return QSize(400, 70);
    }
};

#endif // ROMDELEGATE_H
