#ifndef PATH_H
#define PATH_H

#include<stdlib.h>

#include<QString>
#include<QCoreApplication>
#include<QSettings>

class Path
{
public:
    // All files related to this application should reside here
    static QString appDir()
    {
        QString path = getenv("XDG_CONFIG_HOME");

        return QString("%1/%2/")
               .arg(path.isEmpty() ? getenv("HOME") + QString("/.config") : path)
               .arg(QCoreApplication::applicationName());
    }

    // The directory with emulator user files
    static QString emuDir()
    {
        QString path = getenv("XDG_CONFIG_HOME");

        return (path.isEmpty() ? getenv("HOME") + QString("/.config") : path) + "/gpspm/";
    }

    // Main configuration file
    static QString cfgFile()
    {
        return appDir() + QCoreApplication::applicationName() + ".conf";
    }

    // Emulator installation directory
    static QString emuRoot()
    {
        return "/opt/gpspm/";
    }

    // Emulator executable
    static QString emuExe()
    {
        return emuRoot() + "gpspm";
    }

    // The directory to be used when searching for ROMs
    static QString romDir()
    {
        return QSettings(cfgFile(), QSettings::IniFormat).value("RomDir", "/home/user/MyDocs/").toString();
    }

    static void setRomDir(QString romDir)
    {
        QSettings(cfgFile(), QSettings::IniFormat).setValue("RomDir", romDir);
    }
};

#endif // PATH_H
