#include "coredialog.h"

CoreDialog::CoreDialog(CoreConfig *config, QWidget *parent) :
    RotatingDialog(parent),
    ui(new Ui::CoreDialog)
{
    ui->setupUi(this);

    this->setAttribute(Qt::WA_DeleteOnClose);

    this->config = config;

    // Set ROM info
    QPalette palette = ui->miscLabel->palette();
    palette.setColor(QPalette::WindowText, QMaemo5Style::standardColor("SecondaryTextColor"));
    ui->miscLabel->setPalette(palette);
    ui->audioLabel->setPalette(palette);
    ui->videoLabel->setPalette(palette);
    ui->commandsLabel->setPalette(palette);

    load();
}

CoreDialog::~CoreDialog()
{
    save();

    delete ui;
}

void CoreDialog::load()
{
    QMaemo5ListPickSelector *selector;
    QStandardItemModel *model;

    // Accelerometer
    ui->accelerometerBox->setChecked(config->accelerometer);

    // Autopause
    ui->autopauseBox->setChecked(config->autopause);

    // Disable sound
    ui->soundDisableBox->setChecked(config->soundDisabled);

    // Sound buffer size
    selector = new QMaemo5ListPickSelector;
    model = new QStandardItemModel(0, 1, selector);
    for (int i = 16; i <= 16384; i*=2) model->appendRow(new QStandardItem(QString::number(i)));
    selector->setModel(model);
    selector->setCurrentIndex(config->soundBuffer);
    ui->soundBufferButton->setPickSelector(selector);

    // Scale
    selector = new QMaemo5ListPickSelector;
    model = new QStandardItemModel(0, 1, selector);
    model->appendRow(new QStandardItem(tr("Original")));
    model->appendRow(new QStandardItem(tr("Double")));
    model->appendRow(new QStandardItem(tr("Triple")));
    model->appendRow(new QStandardItem(tr("Fullscreen")));
    selector->setModel(model);
    selector->setCurrentIndex(config->scale);
    ui->scaleButton->setPickSelector(selector);

    // Filter
    selector = new QMaemo5ListPickSelector;
    model = new QStandardItemModel(0, 1, selector);
    model->appendRow(new QStandardItem(tr("None")));
    model->appendRow(new QStandardItem(tr("Scale2x")));
    model->appendRow(new QStandardItem(tr("Scale3x")));
    model->appendRow(new QStandardItem(tr("Eagle2x")));
    selector->setModel(model);
    selector->setCurrentIndex(config->filter);
    ui->filterButton->setPickSelector(selector);

    // Frameskip type
    selector = new QMaemo5ListPickSelector;
    model = new QStandardItemModel(0, 1, selector);
    model->appendRow(new QStandardItem(tr("Disabled")));
    model->appendRow(new QStandardItem(tr("Automatic")));
    model->appendRow(new QStandardItem(tr("Manual")));
    selector->setModel(model);
    selector->setCurrentIndex(config->frameskipType);
    ui->frameskipTypeButton->setPickSelector(selector);

    // Frameskip value
    selector = new QMaemo5ListPickSelector;
    model = new QStandardItemModel(0, 1, selector);
    for (int i = 0; i <= 9; i++) model->appendRow(new QStandardItem(QString::number(i)));
    selector->setModel(model);
    selector->setCurrentIndex(config->frameskipValue);
    ui->frameskipValueButton->setPickSelector(selector);

    // Random frameskip
    ui->frameskipRandomBox->setChecked(config->frameskipRandom);

    // Execute before
    ui->beforeEdit->setText(config->executeBefore);

    // Execute after
    ui->afterEdit->setText(config->executeAfter);
}

void CoreDialog::save()
{
    config->accelerometer   = ui->accelerometerBox->isChecked();
    config->autopause       = ui->autopauseBox->isChecked();
    config->soundDisabled   = ui->soundDisableBox->isChecked();
    config->soundBuffer     = static_cast<QMaemo5ListPickSelector*>(ui->soundBufferButton->pickSelector())->currentIndex();
    config->scale           = static_cast<QMaemo5ListPickSelector*>(ui->scaleButton->pickSelector())->currentIndex();
    config->filter          = static_cast<QMaemo5ListPickSelector*>(ui->filterButton->pickSelector())->currentIndex();
    config->frameskipType   = static_cast<QMaemo5ListPickSelector*>(ui->frameskipTypeButton->pickSelector())->currentIndex();
    config->frameskipValue  = static_cast<QMaemo5ListPickSelector*>(ui->frameskipValueButton->pickSelector())->currentIndex();
    config->frameskipRandom = ui->frameskipRandomBox->isChecked();
    config->executeBefore   = ui->beforeEdit->text();
    config->executeAfter    = ui->afterEdit->text();

    config->save();
}
