#ifndef CORECONFIG_H
#define CORECONFIG_H

#include "abstractconfig.h"

#include "path.h"

#define DEFAULT_Accelerometer false
#define DEFAULT_Autopause false
#define DEFAULT_Scale 2
#define DEFAULT_Filter 0
#define DEFAULT_FrameskipType 1
#define DEFAULT_FrameskipValue 1
#define DEFAULT_FrameskipRandom false
#define DEFAULT_SoundDisabled false
#define DEFAULT_SoundBuffer 8
#define DEFAULT_ExecuteBefore ""
#define DEFAULT_ExecuteAfter ""

class CoreConfig : public AbstractConfig
{
public:
    bool accelerometer;   // --accelerometer
    bool autopause;       // --autopause
    int  scale;           // --scale N
    int  filter;          // --filter N
    int  frameskipType;   // --frameskip-type N
    int  frameskipValue;  // --frameskip-value N
    bool frameskipRandom; // --random-frameskip
    bool soundDisabled;   // --no-sound
    int  soundBuffer;     // --sound-buffer N
    QString executeBefore;
    QString executeAfter;

    CoreConfig(QString file = QString());

    void save();

private:
    QString group() { return "Core"; }

    bool load(QString file);
};

#endif // CORECONFIG_H
