#include "abstractconfig.h"

// Construct and bind to a file
AbstractConfig::AbstractConfig(QString file)
{
    this->file = file;
}

// Cut off from the underlying file
void AbstractConfig::unbind()
{
    this->file = QString();
}

// Remove related content from the bound file
void AbstractConfig::drop()
{
    QSettings settings(file, QSettings::IniFormat);

    settings.remove(group());

    if (!file.isEmpty() && settings.allKeys().isEmpty()) {
        settings.sync();
        QFile::remove(file);
    }
}

// Check if the bound file contains related entries
bool AbstractConfig::exists()
{
    QSettings settings(file, QSettings::IniFormat); return exists(settings);
}

// Check if the given settings contain related entries
bool AbstractConfig::exists(const QSettings &settings)
{
    return settings.childGroups().contains(group());
}
