/* gameplaySP - pandora backend
 *
 * Copyright (C) 2011 notaz <notasas@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "../common.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <hildon/hildon.h>

int lw,lh;
static GdkImage *image;
#ifdef DIABLO
#include "hildon-animation-actor.h"
#endif

static HildonAnimationActor *actor;
static GtkWidget *window, *drawing;
static unsigned char keymap[65536];
void *pl_vout_buf;
int accel=0;
static int sens,y_def;

enum gpsp_key {
  GKEY_UP       = 1 << 0,
  GKEY_LEFT     = 1 << 1,
  GKEY_DOWN     = 1 << 2,
  GKEY_RIGHT    = 1 << 3,
  GKEY_START    = 1 << 4,
  GKEY_SELECT   = 1 << 5,
  GKEY_L        = 1 << 6,
  GKEY_R        = 1 << 7,
  GKEY_A        = 1 << 8,
  GKEY_B        = 1 << 9,
  GKEY_X        = 1 << 10,
  GKEY_Y        = 1 << 11,
  GKEY_1        = 1 << 12,
  GKEY_2        = 1 << 13,
  GKEY_3        = 1 << 14,
  GKEY_4        = 1 << 15,
  GKEY_MENU     = 1 << 16,
};

u32 button_plat_mask_to_config[PLAT_BUTTON_COUNT] =
{
  GKEY_UP,
  GKEY_LEFT,
  GKEY_DOWN,
  GKEY_RIGHT,
  GKEY_START,
  GKEY_SELECT,
  GKEY_L,
  GKEY_R,
  GKEY_A,
  GKEY_B,
  GKEY_X,
};

u32 gamepad_config_map[PLAT_BUTTON_COUNT] =
{
  BUTTON_ID_UP,
  BUTTON_ID_LEFT,
  BUTTON_ID_DOWN,
  BUTTON_ID_RIGHT,
  BUTTON_ID_START,
  BUTTON_ID_SELECT,
  BUTTON_ID_L,
  BUTTON_ID_R,
  BUTTON_ID_A,
  BUTTON_ID_B,
  BUTTON_ID_FASTFORWARD
};


#define ARRAY_SIZE(x) (sizeof(x) / sizeof(x[0]))
int gkeystate=0;

inline u32 gpsp_plat_joystick_read(void)
{
  return gkeystate;
}
char current_savestate_filename[512];

void hild_quit()
{
	gtk_main_quit();
	exit(0);
}
 
static void
window_key_proxy(GtkWidget *widget,GdkEventKey *event,gpointer user_data)
{
	int key, key1= -1;

	key = keymap[event->hardware_keycode];
	if (key < 11)
		key1 =1<<key;
	else
	switch(key){
	case 11:
	key1=3;break; //ul
	case 12:
	key1=9;break; // dr
	case 13:
	key1=6;break; // ul
	case 14:
	key1=12;break; // dr
	case 15:
	load_state(current_savestate_filename);break;
	case 16:
	 get_savestate_filename_noshot(savestate_slot,current_savestate_filename);
     save_state(current_savestate_filename, pl_vout_buf);break;
	case 17:
	hild_quit();
    break;
	}
	if (key1==-1)return;

	if (event->type == GDK_KEY_PRESS)gkeystate |= (key1 );
    else if (event->type == GDK_KEY_RELEASE) gkeystate &= ~(key1);
		
	
	
}


#include "externs.h"

int maemo_init(int *argc, char **argv)
{
  int ret, w, h;

  FILE* pFile;
	pFile = fopen("/opt/gpspm/conf.gpsp", "r"); // assume the file exists and has data
	int ch;
	int i=0;
	for (i=0;i<65536;i++)
		keymap[i]=255;
	if (NULL != pFile) {
		for(i=0;i<18;i++){
			fscanf(pFile, "%i",&ch);
			keymap[ch]=i;
		}
		fclose(pFile);
	}
sens=150;y_def=150;


  
  gtk_init (argc, &argv);
#ifdef DIABLO
window = hildon_window_new ();
#else
window = hildon_stackable_window_new ();
#endif
gtk_widget_realize (window);
gtk_window_fullscreen (GTK_WINDOW(window));

g_signal_connect (G_OBJECT (window), "key-press-event",G_CALLBACK (window_key_proxy), NULL);
g_signal_connect (G_OBJECT (window), "key-release-event",G_CALLBACK (window_key_proxy), NULL);
g_signal_connect (G_OBJECT (window), "delete_event",G_CALLBACK (hild_quit), NULL);

gtk_widget_add_events (window,GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);


	actor = HILDON_ANIMATION_ACTOR (hildon_animation_actor_new());
	hildon_animation_actor_set_parent (actor, GTK_WINDOW (window));

	drawing = gtk_image_new ();


	gtk_container_add (GTK_CONTAINER (actor), drawing);
	gtk_widget_show_all (GTK_WIDGET (actor));
	gtk_widget_show_all (GTK_WIDGET (window));

	
	
  ret = SDL_Init(SDL_INIT_AUDIO | SDL_INIT_NOPARACHUTE);
  if (ret != 0) {
    fprintf(stderr, "SDL_Init failed: %s\n", SDL_GetError());
    exit(1);
  }

  w = 240;
  h = 160;

  screen_scale = 2;
  load_config_file();
  gamepak_filename[0] = 0;

  
  // ========================================================================
  
  
char * rom;
  
char ready_to_go=0;
  if(*argc > 1)
  {
  int i;
  for (i = 1; i < *argc; i++) {
	if (!strcmp(argv[i], "-cdfile")) {
	if ((++i) >= *argc) break;
	rom=argv[i];
	ready_to_go=1;
	}else if (!strcmp(argv[i], "-breack")){
	if (i+1 >= *argc) break;
	current_debug_state = COUNTDOWN_BREAKPOINT;
    breakpoint_value = strtol(argv[++i], NULL, 16);
	}else if (!strcmp(argv[i], "-accel"))accel=1;
	else if (!strcmp(argv[i], "-fskip"))		current_frameskip_type=atoi(argv[++i]);
	else if (!strcmp(argv[i], "-fskip_value"))	frameskip_value=atoi(argv[++i]);
	else if (!strcmp(argv[i], "-fstype"))		random_skip=atoi(argv[++i]);
	else if (!strcmp(argv[i], "-screen"))		screen_scale=atoi(argv[++i]);
	else if (!strcmp(argv[i], "-nosound"))		global_enable_audio=0;
	else if (!strcmp(argv[i], "-sound_buffer")) audio_buffer_size_number=atoi(argv[++i]);
	else if (!strcmp(argv[i], "-help")){
	printf ("gpSP - gameboy advance emulator\n"\
	        "usage: gpsp -cdfile file.gba [-breack a][-accel][-screen b][-nosound][-fskip c][-fskip_value d][-fstype e][-sound_buffer f]\n"\
			"\ta - breakpoint_value\n\tb - no scale (0),2x (1),3x (2),fullscreen (3)\n"\
			"\tc - no (0), auto (1), manual (2)\n\td - maximum(auto) or constant(manual) frames to skip\n"\
			"\te - use 1 if image flickering\n"
			"\tf - size (in bytes) of the audio buffer.\n"\
			"use http://talk.maemo.org/showthread.php?t=67038 to report bugs\n"
		   );
		   return 0;
	}
  }
  }

  if (ready_to_go!=1){
    printf ("Rom doesn't specified\n" \
	        "gpSP - gameboy advance emulator\n"\
			"use -h[elp] for more info\n");return 0;}
			
  init_video();
  
  int ret2;
  ret2 = load_bios("/opt/gpspm/gba_bios.bin");
  if (ret2 != 0)
  {
  printf ("No bios presented");
  quit();
  }
  if(bios_rom[0] != 0x18)
  printf ("You have an incorrect BIOS image. ");
  init_main();
  init_sound();
  //init_input();
  video_resolution_large();
	
	if(load_gamepak(rom) == -1){
	printf ("Error while loading rom %s",argv[i]);
	return -1;
	}
	
	
set_clock_speed();
set_gba_resolution(screen_scale);
video_resolution_small();
	
init_cpu();
init_memory();

last_frame = 0;

trigger_ext_event();
execute_arm_translate(execute_cycles);
execute_arm(execute_cycles);

  return 0;
}

void gpsp_plat_quit(void)
{

  SDL_Quit();
}



u32 gpsp_plat_buttons_to_cursor(u32 buttons)
{
return 0;
}

void *fb_flip_screen(void)
{
if (accel==1){
int x, y, z;
FILE* f = fopen( "/sys/class/i2c-adapter/i2c-3/3-001d/coord", "r" );
if( !f ) {printf ("err in accel"); exit(1);}
fscanf( f, "%d %d %d", &x, &y, &z );
fclose( f );

if( x > sens ) gkeystate |= 1 << 1;
else if( x < -sens ) gkeystate |= 1 << 3;
else {gkeystate &= ~(1 << 1);gkeystate &= ~(1 << 3);}

y+=y_def;
if( y > sens )gkeystate |= 1 << 0;
else if( y < -sens ) gkeystate |= 1 << 2; 
else {gkeystate &= ~(1 << 2);gkeystate &= ~(1 << 0);}
}
gtk_widget_queue_draw (drawing);
/* process GTK+ events */
	while (gtk_events_pending())
		gtk_main_iteration();
	return pl_vout_buf;
	
}

void fb_wait_vsync(void)
{
 
}

void fb_set_mode(int w, int h, int buffers, int scale, int filter)
{
  int lx, ly;
  lw = w, lh = h;
  switch (scale) {
    case 0:
      lw = w;
      lh = h;
      break;
    case 1:
      lw = w * 2;
      lh = h * 2;
      break;
    case 2:
      lw = w * 3;
      lh = h * 3;
      break;
    case 3:
      lw = 800;
      lh = 480;
      break;
	case 15:
		lw=800;
		lh=480;
		break;
    default:
      fprintf(stderr, "unknown scale: %d\n", scale);
      break;
  }
  if (lw > 800)
    lw = 800;
  if (lh > 480)
    lh = 480;
  lx = 800 / 2 - lw / 2;
  ly = 480 / 2 - lh / 2;

  
 if (image) gdk_image_destroy(image);
	image = gdk_image_new( GDK_IMAGE_FASTEST, gdk_visual_get_system(), w, h );

	pl_vout_buf = (void *) image->mem;



	gtk_image_set_from_image (GTK_IMAGE(drawing), image, NULL);
	gtk_window_resize (GTK_WINDOW (actor), w, h);
	hildon_animation_actor_set_position (actor, lx, ly );
	hildon_animation_actor_set_scale (actor,(gdouble)lw/ (gdouble)w,(gdouble)lh / (gdouble)h);

}

// vim:shiftwidth=2:expandtab
