/* gameplaySP - pandora backend
 *
 * Copyright (C) 2011 notaz <notasas@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "../common.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <hildon/hildon.h>

static GdkImage *image;
static HildonAnimationActor *actor;
static GtkWidget *window, *drawing;
static int keymap[65536];
void *pl_vout_buf;

enum gpsp_key {
  GKEY_UP       = 1 << 0,
  GKEY_LEFT     = 1 << 1,
  GKEY_DOWN     = 1 << 2,
  GKEY_RIGHT    = 1 << 3,
  GKEY_START    = 1 << 4,
  GKEY_SELECT   = 1 << 5,
  GKEY_L        = 1 << 6,
  GKEY_R        = 1 << 7,
  GKEY_A        = 1 << 8,
  GKEY_B        = 1 << 9,
  GKEY_X        = 1 << 10,
  GKEY_Y        = 1 << 11,
  GKEY_1        = 1 << 12,
  GKEY_2        = 1 << 13,
  GKEY_3        = 1 << 14,
  GKEY_4        = 1 << 15,
  GKEY_MENU     = 1 << 16,
};

u32 button_plat_mask_to_config[PLAT_BUTTON_COUNT] =
{
  GKEY_LEFT,
  GKEY_RIGHT,
  GKEY_UP,
  GKEY_DOWN,
  GKEY_L,
  GKEY_R,
  GKEY_A,
  GKEY_B,
  GKEY_SELECT,
  GKEY_START,
  GKEY_X,
  GKEY_Y,
  GKEY_1,
  GKEY_2,
  GKEY_3,
  GKEY_4,
  GKEY_MENU,
};

u32 gamepad_config_map[PLAT_BUTTON_COUNT] =
{
  BUTTON_ID_UP,                 // Up
  BUTTON_ID_LEFT,               // Left
  BUTTON_ID_DOWN,               // Down
  BUTTON_ID_RIGHT,              // Right
  BUTTON_ID_START,              // Start
  BUTTON_ID_SELECT,             // Select
  BUTTON_ID_L,                  // Ltrigger
  BUTTON_ID_R,                  // Rtrigger
  BUTTON_ID_FPS,                // A
  BUTTON_ID_A,                  // B
  BUTTON_ID_B,                  // X
  BUTTON_ID_MENU,               // Y
  BUTTON_ID_SAVESTATE,          // 1
  BUTTON_ID_LOADSTATE,          // 2
  BUTTON_ID_FASTFORWARD,        // 3
  BUTTON_ID_NONE,               // 4
  BUTTON_ID_MENU                // Space
};

static const u8 gkey_to_cursor[32] = {
  [0 ... 31] = CURSOR_NONE,
  [0] = CURSOR_UP, CURSOR_LEFT, CURSOR_DOWN, CURSOR_RIGHT, CURSOR_NONE, CURSOR_NONE,
  CURSOR_L, CURSOR_R, CURSOR_SELECT, CURSOR_SELECT, CURSOR_EXIT, CURSOR_BACK,
};

struct vout_fbdev *fb;

static int omap_setup_layer(int fd, int enabled, int x, int y, int w, int h, int first_call)
{
/*	
  struct omapfb_plane_info pi = { 0, };
  struct omapfb_mem_info mi = { 0, };
  int ret;
  ret = ioctl(fd, OMAPFB_QUERY_PLANE, &pi);
  if (ret != 0) {
    perror("QUERY_PLANE");
    return -1;
  }

  ret = ioctl(fd, OMAPFB_QUERY_MEM, &mi);
  if (ret != 0) {
    perror("QUERY_MEM");
    return -1;
  }

 
  if (pi.enabled) {
    pi.enabled = 0;
    ret = ioctl(fd, OMAPFB_SETUP_PLANE, &pi);
    if (ret != 0)
      perror("SETUP_PLANE");
  }

  if (first_call) {
    mi.size = 640*512*3*3;
    ret = ioctl(fd, OMAPFB_SETUP_MEM, &mi);
    if (ret != 0) {
      perror("SETUP_MEM");
      return -1;
    }
  }

  pi.pos_x = x;
  pi.pos_y = y;
  pi.out_width = w;
  pi.out_height = h;
  pi.enabled = enabled;

  ret = ioctl(fd, OMAPFB_SETUP_PLANE, &pi);
  if (ret != 0) {
    perror("SETUP_PLANE");
    return -1;
  }

  return 0;*/
}

#define ARRAY_SIZE(x) (sizeof(x) / sizeof(x[0]))
int gkeystate=0;

inline u32 gpsp_plat_joystick_read(void)
{
  return gkeystate;
}

static void
window_key_proxy(GtkWidget *widget,GdkEventKey *event,gpointer user_data)
{
	int key, psxkey1 = -1;

	key = keymap[event->hardware_keycode];
	if (key ==164)return;

	if (key < PLAT_BUTTON_COUNT)
		psxkey1 =key;

	if (event->type == GDK_KEY_PRESS) 
		gkeystate |= (1<<psxkey1 );
    else if (event->type == GDK_KEY_RELEASE) 
		gkeystate &= ~(1<<psxkey1);
	
	
}

void hildon_quit()
{
	gtk_main_quit();
	exit(0);
}

void gpsp_plat_init(int *argc, char ***argv)
{
  int ret, w, h;

  FILE* pFile;
	pFile = fopen("conf.gpsp", "r"); // assume the file exists and has data
	int ch;
	int i=0;
	for (i=0;i<65536;i++)
		keymap[i]=164;
	if (NULL != pFile) {
		for(i=0;i<17;i++){
			fscanf(pFile, "%i",&ch);
			keymap[ch]=i;
		}
		fclose(pFile);
	}
	
  ret = SDL_Init(SDL_INIT_AUDIO | SDL_INIT_NOPARACHUTE);
  if (ret != 0) {
    fprintf(stderr, "SDL_Init failed: %s\n", SDL_GetError());
    exit(1);
  }

  w = 240;
  h = 160;

  
  gtk_init (argc, argv);

window = hildon_stackable_window_new ();
gtk_widget_realize (window);
gtk_window_fullscreen (GTK_WINDOW(window));

g_signal_connect (G_OBJECT (window), "key-press-event",G_CALLBACK (window_key_proxy), NULL);
g_signal_connect (G_OBJECT (window), "key-release-event",G_CALLBACK (window_key_proxy), NULL);
g_signal_connect (G_OBJECT (window), "delete_event",G_CALLBACK (hildon_quit), NULL);

gtk_widget_add_events (window,GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

	actor = HILDON_ANIMATION_ACTOR (hildon_animation_actor_new());
	hildon_animation_actor_set_position (actor, 40, 0 );
	hildon_animation_actor_set_parent (actor, GTK_WINDOW (window));

	drawing = gtk_image_new ();

	gtk_container_add (GTK_CONTAINER (actor), drawing);

	gtk_widget_show_all (GTK_WIDGET (actor));
	gtk_widget_show_all (GTK_WIDGET (window));

  // default to 3x scale
  screen_scale = 3;
}

void gpsp_plat_quit(void)
{

  SDL_Quit();
}



u32 gpsp_plat_buttons_to_cursor(u32 buttons)
{
  int i;

  if (buttons == 0)
    return CURSOR_NONE;

  for (i = 0; (buttons & 1) == 0; i++, buttons >>= 1)
    ;

  return gkey_to_cursor[i];
}

void *fb_flip_screen(void)
{
gtk_widget_queue_draw (drawing);
/* process GTK+ events */
	while (gtk_events_pending())
		gtk_main_iteration();

	return pl_vout_buf;
	
}

void fb_wait_vsync(void)
{
 
}

void fb_set_mode(int w, int h, int buffers, int scale, int filter)
{
  int lx, ly, lw = w, lh = h;
  switch (scale) {
    case 0:
      lw = w;
      lh = h;
      break;
    case 1:
      lw = w * 2;
      lh = h * 2;
      break;
    case 2:
      lw = w * 3;
      lh = h * 3;
      break;
    case 3:
      lw = 800;
      lh = 480;
      break;
    case 15:
      lw = w * 2;
      lh = h + h /2;
      break;
    default:
      fprintf(stderr, "unknown scale: %d\n", scale);
      break;
  }
  if (lw > 800)
    lw = 800;
  if (lh > 480)
    lh = 480;
  lx = 800 / 2 - lw / 2;
  ly = 480 / 2 - lh / 2;

  
 if (image) gdk_image_destroy(image);
	image = gdk_image_new( GDK_IMAGE_FASTEST, gdk_visual_get_system(), w, h );

	pl_vout_buf = (void *) image->mem;

	gtk_image_set_from_image (GTK_IMAGE(drawing), image, NULL);

	gtk_window_resize (GTK_WINDOW (actor), w, h);
	hildon_animation_actor_set_scale (actor,(gdouble)720 / (gdouble)w,(gdouble)480 / (gdouble)h);
	
}

// vim:shiftwidth=2:expandtab
