#include "glatitude.h"

GoogleLatitude::GoogleLatitude(QObject *parent) : QObject(parent) {
    user = "";
    pass = "";
    latitude = 0.;
    longitude = 0.;
    accuracy = 0.;
    interval = 120;

    worker = new QNetworkAccessManager();
    connect(worker, SIGNAL(finished(QNetworkReply *)), this, SLOT(finishedreply(QNetworkReply *)));

    urllogin = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview");
    urldologin = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLoginAuth?service=friendview");
    urlupdate = QUrl::fromEncoded("http://maps.google.com/glm/mmap/mwmfr?hl=en");

    lastupdate = 0;
    login_error = false;
}

void GoogleLatitude::login(QString u, QString p) {
    if ( !u.contains('@') ) u.append("@gmail.com");
    user = u;
    pass = p;
}

void GoogleLatitude::freq(int f) {
    interval = f;
}

void GoogleLatitude::reset() {
    lastupdate = 0;
    login_error = false;
    set(latitude, longitude, accuracy);
}

void GoogleLatitude::set(double la, double lo, double ac) {
    latitude = la;
    longitude = lo;
    accuracy = ac;

    qDebug() << "GoogleLatitude: set la = " << la << " lo = " << lo << " ac = " << ac;
    qDebug() << "GoogleLatitude: set lastupdate = " << lastupdate << " current = " << QDateTime::currentDateTime().toUTC().toTime_t();
    if (login_error) return;
    if (la*lo == 0) return;
    if ( QDateTime::currentDateTime().toUTC().toTime_t() < lastupdate + interval ) return;
    worker->get(QNetworkRequest(urllogin));
}

void GoogleLatitude::finishedreply(QNetworkReply *r) {
    if ( r->url() == urllogin ) {
        qDebug() << "GoogleLatitude: login";
        QString aidis = r->readAll();
        QRegExp regexp ("type=\"hidden\".*name=\"GALX\".*value=\"(.*)\"");
        regexp.setMinimal(1);
        regexp.indexIn(aidis, 1);
        QString googleGALX = regexp.capturedTexts().last();

        QByteArray datalogin;
        datalogin += "&service=friendview";
        datalogin += "&GALX=" + googleGALX;
        datalogin += "&Email=" + user;
        datalogin += "&Passwd=" + pass;
        worker->post(QNetworkRequest(urldologin), datalogin);
    } else if ( r->url() == urldologin ) {
        qDebug() << "GoogleLatitude: dologin";
        QByteArray datagps;
        datagps += "t=ul";
        datagps += "&lat=" + QString::number(latitude);
        datagps += "&lng=" + QString::number(longitude);
        datagps += "&accuracy=" + QString::number(accuracy);

        QNetworkRequest request(urlupdate);
        request.setRawHeader("X-ManualHeader", QString("true").toAscii() );
        worker->post(request, datagps);
    } else if ( r->url() == urlupdate ) {
        QString output = r->readAll();
        QRegExp regexp ("Authentication required");
        if (regexp.indexIn(output, 1) != -1) {
            qDebug() << "GoogleLatitude: update error";
            login_error = true;
            emit ERROR();
        } else {
            lastupdate = QDateTime::currentDateTime().toUTC().toTime_t();
            qDebug() << "GoogleLatitude: update ok " << "lastupdate = " << lastupdate;
            emit OK();
        }
    } else {
        qDebug() << "GoogleLatitude Error url:" << r->url();
        qDebug() << r->rawHeaderList();
        qDebug() << r->readAll();
    }
}
