#include "daemon.h"

Daemon::Daemon(QObject *parent) : QObject(parent) {
    setting = new QSettings();
    glatitude = new GoogleLatitude(this);
    gps = new GpsMaemo5(this);
    connect(gps, SIGNAL(fix()), this, SLOT(set()));
    connect(glatitude, SIGNAL(OK()), this, SLOT(daemon_OK()));
    connect(glatitude, SIGNAL(ERROR()), this, SLOT(daemon_ERROR()));
}

void Daemon::set() {
    qDebug() << "Daemon: set";
    glatitude->login(setting->value("user","my_username").toString(),
                     setting->value("pass","my_password").toString());
    glatitude->freq(setting->value("freq","120").toInt());
    glatitude->set(gps->get_lat(),
                   gps->get_lon(),
                   gps->get_acc());
}

void Daemon::daemon_OK() {
    qDebug() << "Daemon: send";
}

void Daemon::daemon_ERROR() {
    qDebug() << "Daemon: no auth";
    QCoreApplication::exit();
}
