#include "gps.h"

GpsMaemo5::GpsMaemo5(QObject *parent) : QObject(parent) {
    latitude = 0;
    longitude = 0;
    accuracy = 0;
#ifdef Q_WS_MAEMO_5
    control = location_gpsd_control_get_default();
    device = (LocationGPSDevice*) g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);

    g_signal_connect(device, "changed", G_CALLBACK(GpsMaemo5_changed), this);
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_ACWP, NULL);
    g_object_set(G_OBJECT(control), "preferred-interval", LOCATION_INTERVAL_120S, NULL);

    location_gpsd_control_start(control);
#else
    urlloc = QUrl::fromEncoded("http://www.google.com/loc/json");
    worker = new QNetworkAccessManager();
    connect(worker, SIGNAL(finished(QNetworkReply *)), this, SLOT(finishedreply(QNetworkReply *)));

    worker->post(QNetworkRequest(urlloc), QByteArray("{version:\"1.1.0\"}"));
#endif // Q_WS_MAEMO_5
}

#ifdef Q_WS_MAEMO_5
void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps) {
    if (device->fix) {
        if (device->fix->fields) {
            g_print("GpsMaemo5 lat = %f, long = %f, eph = %f\n", gps->device->fix->latitude, gps->device->fix->longitude, gps->device->fix->eph/100.);
            gps->latitude = gps->device->fix->latitude;
            gps->longitude = gps->device->fix->longitude;
            gps->accuracy = gps->device->fix->eph/100.;
            emit gps->fix();
        }
    }
}
#else
void GpsMaemo5::finishedreply(QNetworkReply *r) {
    if ( r->url() == urlloc ) {
        QString loc = r->readAll();
        QRegExp regexp ("\\{\"latitude\":(.*),\"longitude\":(.*),\"accuracy\":(.*)\\}");
        regexp.setMinimal(1);
        regexp.indexIn(loc, 1);
        latitude = regexp.capturedTexts().at(1).toDouble();
        longitude = regexp.capturedTexts().at(2).toDouble();
        accuracy = regexp.capturedTexts().at(3).toDouble();
        qDebug() << "GpsMaemo5 lat = " << latitude << " long = " << longitude << " acc = " << accuracy;
        emit fix();
    } else {
        qDebug() << "GpsMaemo5 Error url:" << r->url();
        qDebug() << r->rawHeaderList();
        qDebug() << r->readAll();
    }
}
#endif // Q_WS_MAEMO_5
