#ifndef GPSFAKE_H
#define GPSFAKE_H

#include <QObject>

#ifndef Q_WS_MAEMO_5

class GpsMaemo5 : public QObject {
    Q_OBJECT

signals:
    void getOK();
    void getOK_acwp();
    void getOK_agnss();

public slots:
    void get_acwp() { accuracy = 1; emit getOK_acwp(); }
    void get_agnss() { accuracy = 2; emit getOK_agnss(); }

public:
    GpsMaemo5(QObject *parent = 0) : QObject(parent) {
        latitude=0;
        longitude=0;
        accuracy=0;
    }
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }
    void stop() {}
    void restart() {}

private:
    double latitude;
    double longitude;
    double accuracy;
};

#endif
#endif // GPSFAKE_H
