#ifndef GPS_H
#define GPS_H

#include <QObject>

#ifdef Q_WS_MAEMO_5

extern "C" {
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
}

class GpsMaemo5 : public QObject {
    Q_OBJECT

signals:
    void getOK();
    void getOK_acwp();
    void getOK_agnss();

public slots:
    void get_acwp();
    void get_agnss();

public:
    GpsMaemo5(QObject *parent = 0);
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }
    void stop();
    void restart();
    friend void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps);

private:
    double latitude;
    double longitude;
    double accuracy;

    int usegps;

    GMainLoop *loop;
    LocationGPSDControl *control;
    LocationGPSDevice *device;

};

void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps);

#endif
#endif // GPS_H
