#include "gps.h"

GpsMaemo5::GpsMaemo5(QObject *parent) : QObject(parent) {
    latitude = 0;
    longitude = 0;
    accuracy = 0;
    usegps = -1;

    control = location_gpsd_control_get_default();
    device = (LocationGPSDevice*) g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);
    g_signal_connect(device, "changed", G_CALLBACK(GpsMaemo5_changed), this);
}

void GpsMaemo5::get_acwp() {
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_ACWP, NULL);
    usegps = 0;
    restart();
}

void GpsMaemo5::get_agnss() {
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_AGNSS, NULL);
    usegps = 1;
    restart();
}

void GpsMaemo5::stop() {
    location_gpsd_control_stop(control);
}

void GpsMaemo5::restart() {
    location_gpsd_control_stop(control);
    location_gpsd_control_start(control);
}

void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps) {
    if (device->fix) {
        if (device->fix->fields & LOCATION_GPS_DEVICE_LATLONG_SET) {
            g_print("lat = %f, long = %f, eph = %f\n", device->fix->latitude, device->fix->longitude, device->fix->eph/100.);
            gps->latitude = device->fix->latitude;
            gps->longitude = device->fix->longitude;
            gps->accuracy = device->fix->eph/100.;

            if ( gps->usegps == 0) {
                emit gps->getOK_acwp();
            } else if ( gps->usegps == 1 ) {
                if ( gps->device->satellites_in_use > 0 ) {
                    emit gps->getOK_agnss();
                }
            } else {
                emit gps->getOK();
            }
        }
    }
}
