#ifndef LATITUDEWIDGET_H
#define LATITUDEWIDGET_H

#include <QWidget>
#include <QHBoxLayout>
#include <QFormLayout>
#include <QPushButton>
#include <QLineEdit>
#include <QFile>
#include <QDir>
#include <QTextStream>
#include <QTimer>
#include "googlelatitude.h"

class LatitudeWidget : public QWidget {
    Q_OBJECT

public slots:
    void get();
    void gsetOK();
    void gsetERROR();
    void gset();

public:
    LatitudeWidget();

private slots:
    void set();
    void save();
    void load();

private:
    GoogleLatitude glatitude;
    // info
    QString user;
    QString pass;
    double latitude;
    double longitude;
    double accuracy;
    // gui
    QWidget *menu;
    QHBoxLayout *menu_layout;
    // login
    QFormLayout *login_layout;
    QLineEdit *login_user;
    QLineEdit *login_pass;
    QPushButton *login_up;
    // location
    QFormLayout *location_layout;
    QLineEdit *location_lat;
    QLineEdit *location_lon;
    QLineEdit *location_acc;
    // stuff
    QTimer *timer;
};

#endif // LATITUDEWIDGET_H
