
#include <googleimages/google-images-art-downloader.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdio.h>

typedef DBusGProxy ProviderDBusProxy;
typedef DBusGProxyClass ProviderDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _provider_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_provider_introspect (Provider* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_provider_property_get_all (Provider* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_provider_Fetch (Provider* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult provider_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static void provider_dbus_proxy_Fetch (Provider* self, const char* artist, const char* album, const char* kind);
static void provider_dbus_proxy_interface_init (ProviderIface* iface);
enum  {
	GOOGLE_IMAGES_DUMMY_PROPERTY
};
static void google_images_real_Fetch (Provider* base, const char* artist, const char* album, const char* kind);
static gpointer google_images_parent_class = NULL;
void _google_images_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_google_images_introspect (GoogleImages* self, DBusConnection* connection, DBusMessage* message);
static ProviderIface* google_images_provider_parent_iface = NULL;
guint _dynamic_request_name0 (DBusGProxy* self, const char* param1, guint param2, GError** error);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);

static const DBusObjectPathVTable _provider_dbus_path_vtable = {_provider_dbus_unregister, provider_dbus_message};
static const _DBusObjectVTable _provider_dbus_vtable = {provider_dbus_register_object};
static const DBusObjectPathVTable _google_images_dbus_path_vtable = {_google_images_dbus_unregister, google_images_dbus_message};
static const _DBusObjectVTable _google_images_dbus_vtable = {google_images_dbus_register_object};


void provider_Fetch (Provider* self, const char* artist, const char* album, const char* kind) {
	PROVIDER_GET_INTERFACE (self)->Fetch (self, artist, album, kind);
}


void _provider_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_provider_introspect (Provider* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.nokia.albumart.Provider\">\n  <method name=\"Fetch\">\n    <arg name=\"artist\" type=\"s\" direction=\"in\"/>\n    <arg name=\"album\" type=\"s\" direction=\"in\"/>\n    <arg name=\"kind\" type=\"s\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_provider_property_get_all (Provider* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "com.nokia.albumart.Provider") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_provider_Fetch (Provider* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	const char* artist;
	const char* _tmp1;
	const char* album;
	const char* _tmp2;
	const char* kind;
	const char* _tmp3;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "sss")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	artist = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1);
	dbus_message_iter_next (&iter);
	artist = g_strdup (_tmp1);
	album = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp2);
	dbus_message_iter_next (&iter);
	album = g_strdup (_tmp2);
	kind = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp3);
	dbus_message_iter_next (&iter);
	kind = g_strdup (_tmp3);
	provider_Fetch (self, artist, album, kind);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	return reply;
}


DBusHandlerResult provider_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_provider_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_provider_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.nokia.albumart.Provider", "Fetch")) {
		reply = _dbus_provider_Fetch (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void provider_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_provider_dbus_path_vtable, object);
	}
}


static void provider_base_init (ProviderIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_PROVIDER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_provider_dbus_vtable));
	}
}


GType provider_get_type (void) {
	static GType provider_type_id = 0;
	if (provider_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ProviderIface), (GBaseInitFunc) provider_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "Provider", &g_define_type_info, 0);
	}
	return provider_type_id;
}


G_DEFINE_TYPE_EXTENDED (ProviderDBusProxy, provider_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_PROVIDER, provider_dbus_proxy_interface_init));
Provider* provider_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Provider* self;
	char* filter;
	self = g_object_new (provider_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.nokia.albumart.Provider", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), provider_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


DBusHandlerResult provider_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void provider_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), provider_dbus_proxy_filter, self);
	G_OBJECT_CLASS (provider_dbus_proxy_parent_class)->dispose (self);
}


static void provider_dbus_proxy_class_init (ProviderDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->dispose = provider_dbus_proxy_dispose;
}


static void provider_dbus_proxy_init (ProviderDBusProxy* self) {
}


static void provider_dbus_proxy_Fetch (Provider* self, const char* artist, const char* album, const char* kind) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp4;
	const char* _tmp5;
	const char* _tmp6;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.nokia.albumart.Provider", "Fetch");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp4 = artist;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp4);
	_tmp5 = album;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp5);
	_tmp6 = kind;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp6);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void provider_dbus_proxy_interface_init (ProviderIface* iface) {
	iface->Fetch = provider_dbus_proxy_Fetch;
}


static void google_images_real_Fetch (Provider* base, const char* artist, const char* album, const char* kind) {
	GoogleImages * self;
	GError * inner_error;
	guint u;
	guint hread;
	char** _tmp1;
	gint pieces_size;
	gint pieces_length1;
	char** _tmp0;
	char** pieces;
	char* stitched;
	gboolean first;
	gboolean _tmp2;
	gboolean _tmp3;
	char* _tmp6;
	char** _tmp8;
	char** _tmp7;
	char* _tmp11;
	char* _tmp13;
	char* _tmp12;
	GFile* _tmp14;
	GFile* google_search;
	self = (GoogleImages*) base;
	g_return_if_fail (artist != NULL);
	g_return_if_fail (album != NULL);
	g_return_if_fail (kind != NULL);
	inner_error = NULL;
	u = (guint) 0;
	hread = (guint) 0;
	_tmp1 = NULL;
	_tmp0 = NULL;
	pieces = (_tmp1 = _tmp0 = g_strsplit (artist, " ", -1), pieces_length1 = _vala_array_length (_tmp0), pieces_size = pieces_length1, _tmp1);
	stitched = g_strdup ("");
	first = TRUE;
	if (kind == NULL) {
		kind = "album";
	}
	_tmp2 = FALSE;
	if (album == NULL) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = _vala_strcmp0 (album, "") == 0;
	}
	if (_tmp2) {
		album = "  ";
	}
	_tmp3 = FALSE;
	if (artist == NULL) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = _vala_strcmp0 (artist, "") == 0;
	}
	if (_tmp3) {
		artist = "  ";
	}
	while (pieces[u] != NULL) {
		char* _tmp5;
		if (!first) {
			char* _tmp4;
			_tmp4 = NULL;
			stitched = (_tmp4 = g_strconcat (stitched, "+", NULL), stitched = (g_free (stitched), NULL), _tmp4);
		}
		_tmp5 = NULL;
		stitched = (_tmp5 = g_strconcat (stitched, pieces[u], NULL), stitched = (g_free (stitched), NULL), _tmp5);
		u++;
		first = FALSE;
	}
	_tmp6 = NULL;
	stitched = (_tmp6 = g_strconcat (stitched, "+", NULL), stitched = (g_free (stitched), NULL), _tmp6);
	u = (guint) 0;
	first = TRUE;
	_tmp8 = NULL;
	_tmp7 = NULL;
	pieces = (_tmp8 = _tmp7 = g_strsplit (album, " ", -1), pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL), pieces_length1 = _vala_array_length (_tmp7), pieces_size = pieces_length1, _tmp8);
	while (pieces[u] != NULL) {
		char* _tmp10;
		if (!first) {
			char* _tmp9;
			_tmp9 = NULL;
			stitched = (_tmp9 = g_strconcat (stitched, "+", NULL), stitched = (g_free (stitched), NULL), _tmp9);
		}
		_tmp10 = NULL;
		stitched = (_tmp10 = g_strconcat (stitched, pieces[u], NULL), stitched = (g_free (stitched), NULL), _tmp10);
		u++;
		first = FALSE;
	}
	_tmp11 = NULL;
	stitched = (_tmp11 = g_strconcat (stitched, "+album+cover", NULL), stitched = (g_free (stitched), NULL), _tmp11);
	/* Start the query on Google images*/
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp14 = NULL;
	google_search = (_tmp14 = g_file_new_for_uri (_tmp13 = g_strconcat ("http://images.google.com/images?q=", _tmp12 = g_uri_escape_string (stitched, "+", FALSE), NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp12 = (g_free (_tmp12), NULL), _tmp14);
	{
		gchar* _tmp15;
		gint buffer_size;
		gint buffer_length1;
		gchar* buffer;
		char* asstring;
		GInputStream* stream;
		char* _tmp17;
		const char* _tmp16;
		const char* _tmp18;
		char* found;
		_tmp15 = NULL;
		buffer = (_tmp15 = g_new0 (gchar, 40000), buffer_length1 = 40000, buffer_size = buffer_length1, _tmp15);
		asstring = NULL;
		/* Fetch the first page*/
		stream = (GInputStream*) g_file_read (google_search, NULL, &inner_error);
		if (inner_error != NULL) {
			buffer = (g_free (buffer), NULL);
			asstring = (g_free (asstring), NULL);
			goto __catch0_g_error;
			goto __finally0;
		}
		g_input_stream_read_all (stream, buffer, (gsize) 40000, &hread, NULL, &inner_error);
		if (inner_error != NULL) {
			buffer = (g_free (buffer), NULL);
			asstring = (g_free (asstring), NULL);
			(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
			goto __catch0_g_error;
			goto __finally0;
		}
		buffer[hread] = (gchar) 0;
		_tmp17 = NULL;
		_tmp16 = NULL;
		asstring = (_tmp17 = (_tmp16 = (const char*) buffer, (_tmp16 == NULL) ? NULL : g_strdup (_tmp16)), asstring = (g_free (asstring), NULL), _tmp17);
		/* Find the first result*/
		_tmp18 = NULL;
		found = (_tmp18 = strstr (asstring, "http://tbn0.google.com/images?q=tbn"), (_tmp18 == NULL) ? NULL : g_strdup (_tmp18));
		if (found != NULL) {
			GString* url;
			glong y;
			gint i;
			char* cache_path;
			char* cache_dir;
			char* _tmp29;
			char* _tmp28;
			char* _tmp27;
			char* _tmp26;
			char* _tmp25;
			char* _tmp24;
			char* _tmp23;
			char* _tmp22;
			char* _tmp21;
			char* _tmp20;
			GFile* online_image;
			char* _tmp30;
			GFile* _tmp31;
			GFile* cache_image;
			char* _tmp32;
			url = g_string_new ("");
			y = g_utf8_strlen (found, -1);
			i = 0;
			while (TRUE) {
				gboolean _tmp19;
				_tmp19 = FALSE;
				if (g_utf8_get_char (g_utf8_offset_to_pointer (found, i)) != ' ') {
					_tmp19 = i < y;
				} else {
					_tmp19 = FALSE;
				}
				if (!_tmp19) {
					break;
				}
				g_string_append_unichar (url, g_utf8_get_char (g_utf8_offset_to_pointer (found, i)));
				i++;
			}
			cache_path = NULL;
			cache_dir = g_build_filename (g_get_user_cache_dir (), "media-art", NULL, NULL);
			/* Define cache path = ~/.album_art/MD5 (down (albumartist)).jpeg*/
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp24 = NULL;
			_tmp23 = NULL;
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			cache_path = (_tmp29 = g_build_filename (g_get_user_cache_dir (), "media-art", _tmp28 = g_strconcat (_tmp27 = g_strconcat (_tmp24 = g_strconcat (_tmp23 = g_strconcat (_tmp20 = g_strconcat (kind, "-", NULL), _tmp22 = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp21 = g_utf8_strdown (artist, -1), (gsize) (-1)), NULL), "-", NULL), _tmp26 = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp25 = g_utf8_strdown (album, -1), (gsize) (-1)), NULL), ".jpeg", NULL), NULL, NULL), cache_path = (g_free (cache_path), NULL), _tmp29);
			_tmp28 = (g_free (_tmp28), NULL);
			_tmp27 = (g_free (_tmp27), NULL);
			_tmp26 = (g_free (_tmp26), NULL);
			_tmp25 = (g_free (_tmp25), NULL);
			_tmp24 = (g_free (_tmp24), NULL);
			_tmp23 = (g_free (_tmp23), NULL);
			_tmp22 = (g_free (_tmp22), NULL);
			_tmp21 = (g_free (_tmp21), NULL);
			_tmp20 = (g_free (_tmp20), NULL);
			/* Make sure the directory .album_arts is available*/
			g_mkdir_with_parents (cache_dir, 0770);
			online_image = g_file_new_for_uri (url->str);
			_tmp30 = NULL;
			_tmp31 = NULL;
			cache_image = (_tmp31 = g_file_new_for_path (_tmp30 = g_strconcat (cache_path, ".part", NULL)), _tmp30 = (g_free (_tmp30), NULL), _tmp31);
			/* Copy from Google images to local cache*/
			g_file_copy (online_image, cache_image, G_FILE_COPY_NONE, NULL, NULL, NULL, &inner_error);
			if (inner_error != NULL) {
				(url == NULL) ? NULL : (url = (g_string_free (url, TRUE), NULL));
				cache_path = (g_free (cache_path), NULL);
				cache_dir = (g_free (cache_dir), NULL);
				(online_image == NULL) ? NULL : (online_image = (g_object_unref (online_image), NULL));
				(cache_image == NULL) ? NULL : (cache_image = (g_object_unref (cache_image), NULL));
				buffer = (g_free (buffer), NULL);
				asstring = (g_free (asstring), NULL);
				(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
				found = (g_free (found), NULL);
				goto __catch0_g_error;
				goto __finally0;
			}
			_tmp32 = NULL;
			g_rename (_tmp32 = g_strconcat (cache_path, ".part", NULL), cache_path);
			_tmp32 = (g_free (_tmp32), NULL);
			(url == NULL) ? NULL : (url = (g_string_free (url, TRUE), NULL));
			cache_path = (g_free (cache_path), NULL);
			cache_dir = (g_free (cache_dir), NULL);
			(online_image == NULL) ? NULL : (online_image = (g_object_unref (online_image), NULL));
			(cache_image == NULL) ? NULL : (cache_image = (g_object_unref (cache_image), NULL));
		}
		buffer = (g_free (buffer), NULL);
		asstring = (g_free (asstring), NULL);
		(stream == NULL) ? NULL : (stream = (g_object_unref (stream), NULL));
		found = (g_free (found), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally0:
	if (inner_error != NULL) {
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		stitched = (g_free (stitched), NULL);
		(google_search == NULL) ? NULL : (google_search = (g_object_unref (google_search), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	stitched = (g_free (stitched), NULL);
	(google_search == NULL) ? NULL : (google_search = (g_object_unref (google_search), NULL));
}


/* http://live.gnome.org/MediaArtStorageSpec
 Sample implementation of com.nokia.albumart.Provider that uses Google 
 images's first result as album-art cover. There is of course no certainty 
 that the first result on Google images is indeed the album's cover. But it's
 a good estimate nonetheless.*/
GoogleImages* google_images_construct (GType object_type) {
	GoogleImages * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GoogleImages* google_images_new (void) {
	return google_images_construct (TYPE_GOOGLE_IMAGES);
}


void _google_images_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_google_images_introspect (GoogleImages* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.nokia.albumart.Provider\">\n  <method name=\"Fetch\">\n    <arg name=\"artist\" type=\"s\" direction=\"in\"/>\n    <arg name=\"album\" type=\"s\" direction=\"in\"/>\n    <arg name=\"kind\" type=\"s\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


DBusHandlerResult google_images_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_google_images_introspect (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (provider_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void google_images_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_google_images_dbus_path_vtable, object);
	}
	provider_dbus_register_object (connection, path, object);
}


static void google_images_class_init (GoogleImagesClass * klass) {
	google_images_parent_class = g_type_class_peek_parent (klass);
	g_type_set_qdata (TYPE_GOOGLE_IMAGES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_google_images_dbus_vtable));
}


static void google_images_provider_interface_init (ProviderIface * iface) {
	google_images_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->Fetch = google_images_real_Fetch;
}


static void google_images_instance_init (GoogleImages * self) {
}


GType google_images_get_type (void) {
	static GType google_images_type_id = 0;
	if (google_images_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GoogleImagesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) google_images_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GoogleImages), 0, (GInstanceInitFunc) google_images_instance_init, NULL };
		static const GInterfaceInfo provider_info = { (GInterfaceInitFunc) google_images_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		google_images_type_id = g_type_register_static (G_TYPE_OBJECT, "GoogleImages", &g_define_type_info, 0);
		g_type_add_interface_static (google_images_type_id, TYPE_PROVIDER, &provider_info);
	}
	return google_images_type_id;
}


guint _dynamic_request_name0 (DBusGProxy* self, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


void _main (void) {
	GError * inner_error;
	GMainLoop* loop;
	inner_error = NULL;
	loop = g_main_loop_new (NULL, FALSE);
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		guint request_name_result;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch1_g_error;
			goto __finally1;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		/* try to register service in session bus*/
		request_name_result = _dynamic_request_name0 (bus, "be.pvanhoof.albumart.GoogleImages", (guint) 0, &inner_error);
		if (inner_error != NULL) {
			(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
			(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
			goto __catch1_g_error;
			goto __finally1;
		}
		if (request_name_result == DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
			GoogleImages* server;
			/* start server*/
			server = google_images_new ();
			_vala_dbus_register_object (dbus_g_connection_get_connection (conn), "/be/pvanhoof/albumart/GoogleImages", (GObject*) server);
			g_main_loop_run (loop);
			(server == NULL) ? NULL : (server = (g_object_unref (server), NULL));
		}
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * foo;
		foo = inner_error;
		inner_error = NULL;
		{
			fprintf (stderr, "Oops %s\n", foo->message);
			(foo == NULL) ? NULL : (foo = (g_error_free (foo), NULL));
		}
	}
	__finally1:
	if (inner_error != NULL) {
		(loop == NULL) ? NULL : (loop = (g_main_loop_unref (loop), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(loop == NULL) ? NULL : (loop = (g_main_loop_unref (loop), NULL));
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main ();
	return 0;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}




