/*
  This file is part of "GiveMeFive" - A simple "five in a row" game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/AppInfo.h>
#include <Lum/Button.h>
#include <Lum/Dialog.h>
#include <Lum/Panel.h>
#include <Lum/Text.h>

#include <Lum/Dlg/About.h>

#include <Lum/Model/Action.h>

#include <Lum/OS/Main.h>

#include "config.h"
#include "Control.h"

static Lum::AppInfo info;

class MainDialog : public Lum::Dialog
{
private:
  Lum::Model::ActionRef restartGameAction;
  Lum::Model::ActionRef aboutAction;

  GameAreaRef           gameArea;

public:
  MainDialog()
  : restartGameAction(new Lum::Model::Action),
    aboutAction(new Lum::Model::Action)
  {
    gameArea=new GameArea();

    Observe(restartGameAction);
    Observe(aboutAction);
    Observe(GetOpenedAction());
    Observe(GetClosedAction());
  }

  void PreInit()
  {
    Control     *control;

    control=new Control();
    control->SetFlex(true,true);
    control->SetModel(gameArea);

    SetMain(Lum::HPanel::Create(true,true)
            ->Add(control)
            ->AddSpace()
            ->Add(Lum::VPanel::Create(false,true)
                  ->Add(Lum::Button::Create(L"_Restart Game",restartGameAction,true))));

    Lum::MenuDesc *menu=new Lum::MenuDesc();

    menu
      ->AddMenuItemSub(_ld(menuProject))
        ->AddMenuItemAction(_ld(menuProjectQuit),Lum::OS::qualifierControl,L"q",GetClosedAction());
    menu
      ->AddMenuItemSub(_ld(menuHelp))
        ->AddMenuItemAction(_ld(menuHelpHelp),NULL)
        ->AddMenuItemAction(_ld(menuHelpAbout),aboutAction);

    SetMenu(menu);

    Dialog::PreInit();
  }

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==GetOpenedAction() && GetOpenedAction()->IsFinished()) {
    }
    else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    }
    else if (model==restartGameAction && restartGameAction->IsFinished()) {
      gameArea->RestartGame();
    }
    else if (model==aboutAction && aboutAction->IsFinished()) {
      Lum::Dlg::About::Show(this,info);
    }

    Dialog::Resync(model,msg);
  }
};

class Main : public Lum::OS::MainDialog<MainDialog>
{
public:
  Main()
  {
    info.SetProgram(Lum::Base::StringToWString(PACKAGE_NAME));
    info.SetVersion(Lum::Base::StringToWString(PACKAGE_VERSION));
    info.SetDescription(L"Five in a row...");
    info.SetAuthor(L"Tim Teulings");
    info.SetContact(L"Tim Teulings <tim@teulings.org>");
    info.SetCopyright(L"(c) 2007, Tim Teulings");
    info.SetLicense(L"GNU Public License");
  }

  bool Prepare()
  {
    return Lum::OS::MainDialog<MainDialog>::Prepare();
  }

  void Cleanup()
  {
    Lum::OS::MainDialog<MainDialog>::Cleanup();
  }
};

LUM_MAIN(Main,L"GiveMeFive")

