__author__="Rafael Brundo Uriarte"
__date__ ="$Dec 26, 2009 8:36:52 PM$"

import datetime
import time
import sys
import operator


class List_todo():    

    def __init__(self,todos, preferences):
            self.todos_list = todos
            self.preferences = preferences            
            self.currentView = []
            self.text_searched = ''            
            self.new_todo = 'NONE'

    def _add_todo(self, todo):
        """each new todo must be added here"""
        self.new_todo = todo
        self.todos_list.append(todo)

    def _remove_todo(self, todo):
        """each removed todo must be removed here"""        
        self.todos_list.remove(todo)


    def _get_list_view(self):
        """ Method to create views according to the category and location buttons """
        self.currentView = self.todos_list
        if self.preferences.get_category() != 'NONE':
            self._filter_category()
        if self.preferences.get_location() != 'NONE':
            self._filter_location()
        if self.text_searched != '':
            self._filter_search()            
        self._sort()
                
        if self.new_todo != 'NONE':                
            self.currentView.remove(self.new_todo)
            self.currentView.insert(0,self.new_todo)         
            self.new_todo = 'NONE'
        self._filters_done()
        self._show_not_done_first()
        return self.currentView

    def _sort(self):
        if self.preferences.get_sort_by().lower() == 'title':
            self.currentView.sort(key=operator.attrgetter('title'))
        elif self.preferences.get_sort_by().lower() == 'category':
            listTodosCategoryNone = []
            for todoNONE in self.currentView:
                if todoNONE.category == 'NONE':
                    listTodosCategoryNone.append(todoNONE)

            for todoNONE in listTodosCategoryNone:
                self.currentView.remove(todoNONE)

            self.currentView.sort(key=operator.attrgetter('category'))

            for todoNONE in listTodosCategoryNone:
                self.currentView.append(todoNONE)

        elif self.preferences.get_sort_by().lower() == 'due':
            self._sort_date_time()
            
        elif self.preferences.get_sort_by().lower() == 'priority':
            listTodosPriorityNone = []
            for todoNONE in self.currentView:
                if todoNONE.priority == 'NONE':                    
                    listTodosPriorityNone.append(todoNONE)

            for todoNONE in listTodosPriorityNone:
                self.currentView.remove(todoNONE)

            self.currentView.sort(key=operator.attrgetter('priority'), reverse=True)

            for todoNONE in listTodosPriorityNone:                
                self.currentView.append(todoNONE)
        
    def _sort_date_time(self):
        listDateTimeSorted = []
        newView = []
        for todoCurrent in self.currentView:
            if todoCurrent.dueDateTime != 'NONE':
                try:
                    todoTIME = time.mktime(todoCurrent.dueDateTime.timetuple())
                    listDateTimeSorted.append( (todoTIME ,todoCurrent.uuid) )
                except:                    
                    todoCurrent.dueDateTime = datetime.datetime.strptime(todoCurrent.dueDateTime, '%d-%m-%Y %H:%M')
                    todoTIME = time.mktime(todoCurrent.dueDateTime.timetuple())
                    listDateTimeSorted.append( (todoTIME ,todoCurrent.uuid) )                    
        listDateTimeSorted = sorted(listDateTimeSorted)

        #Append the todos in the end
        for todoCurrent in self.currentView:
            if todoCurrent.dueDateTime == 'NONE':
                listDateTimeSorted.append( ( 'NONE' ,todoCurrent.uuid ) )
        #reorder the original List, I suppose there are better ways but as I have no clue here it go
        for todoCurrent in  listDateTimeSorted:
            for todo in self.currentView:
                if todo.uuid == todoCurrent[1]:
                    newView.append(todo)
        self.currentView = newView

    
    def _filter_category(self):
        """Is set category is not All filter the list by category"""
        tempList = []
        for todo in self.currentView:
            if self.preferences.get_category() == todo.category:
                tempList.append(todo)
        self.currentView = tempList

    def _filter_location(self):
        """Is set location is not All filter the list by location"""
        tempList = []
        for todo in self.currentView:
        # @type todo Todo
            if todo.location != 'NONE':
                if self.preferences.get_location() == todo.location.name:
                    tempList.append(todo)
        self.currentView = tempList


    def _filter_search(self):
        tempList = []
        for todo in self.currentView:
            # @type todo Todo
            if todo.title.lower().find(self.text_searched) != -1:
                tempList.append(todo)
        self.currentView = tempList

    def _invert_todo_completed(self, uuid):
        for todo in self.todos_list:
            if todo.uuid == uuid:
                tempTodo = todo
                if todo.completed == 0:
                    todo.completed = 1
                else:
                    todo.completed = 0
        return tempTodo

    def _set_search(self,text):
        self.text_searched = text

    def _remove_search(self):
        self.text_searched = ''

    def _set_category(self,category):        
        if category == 'All':
            self.preferences.set_category('NONE')
        else:
            self.preferences.set_category(category)            

    def _set_sorting(self,sorting):
        self.preferences.set_sort_by(sorting)        
        
    def _set_location(self,location):
        if location  == 'All':
            self.preferences.set_location('NONE')
        else:
            self.preferences.set_location(location)

    def _retrieve_todo(self,uuid):
        for todo in self.todos_list:           
            if todo.uuid == uuid:
                return todo
        sys.exit('Could not retrive the todo!! Class List_todo method retrieve_todo')


    def _get_sort_options(self):
        return self.preferences.get_option_sort_by()

    def _location_deleted(self,location_name):
        list_to_change = []
        for todo in self.todos_list:
            if todo.location != 'NONE':
                if todo.location.name == location_name:
                    todo.location = 'NONE'
                    list_to_change.append(todo)
        if self.preferences.get_location() == location_name:
            self.preferences.set_location('NONE')
        return list_to_change    
    
    def _filters_done(self):
        if not self.preferences.get_show_completed():
            new_current = []
            for todo in self.currentView:
                if todo.completed == 0:
                    new_current.append(todo)
            self.currentView = new_current
            
    def _show_not_done_first(self):
        if self.preferences.get_not_completed_first():
            current_not = []
            current_done = []
            for todo in self.currentView:
                if todo.completed == 0:
                    current_not.append(todo)
                else:
                    current_done.append(todo)
            self.currentView = current_not
            for todo in current_done:
                self.currentView.append(todo)
