import sys
#!/usr/bin/env python
# -*- coding: UTF-8 -*-
try:
    import sqlite3 # python 2.5
except:
    try:
        from pysqlite2 import dbapi2 as sqlite3
    except:
        print 'This program requires pysqlite2\n http://initd.org/tracker/pysqlite/'
        sys.exit(1)        

import Location
import Reminder
import Todo
import os
import datetime
#Day/month/year - 01/01/1999
#TODO add ACTIVE in the reminder DB
DB_FORMAT = '%d-%m-%Y %H:%M'
FRAMEWORK_VERSION = '0.0.2'
HOME_PATH = os.path.expanduser("~")
#DB_PATH = HOME_PATH + '.GeoToDo/geotodo.db'
DB_PATH = './geotodo.db'
LAUNCH_UPDATE_DB_ONCE = False

class Database:

    def __init__(self, path=None):
        self.db = None
        self.cursor = None        
        if path != None:
            self.path = path
        else:
            self.path = DB_PATH
        if  os.path.exists(DB_PATH):
            try:
                self.db = sqlite3.connect(self.path)
                self.cursor = self.db.cursor()
            except:
                self._create()
        else:
            self._create()
            self.db = sqlite3.connect(self.path)
            self.cursor = self.db.cursor()
            

    def _create(self):        
        self.db = sqlite3.connect(self.path)
        self.cursor = self.db.cursor()
        self.cursor.execute('CREATE TABLE [Location] ([name] TEXT NOT NULL PRIMARY KEY UNIQUE, [description]  TEXT, [latitude] REAL, [longitude] REAL,[zoomLevel] INT);')
        self.db.commit()
        self.cursor.execute('CREATE TABLE [Todo] ([uuid] TEXT NOT NULL PRIMARY KEY UNIQUE, [title] TEXT, [description] TEXT, [dueDateTime] DATETIME, [completed] INTEGER, [priority] INTEGER, [category] TEXT, [location] TEXT REFERENCES [Location](name) ON DELETE SET NULL);')
        self.db.commit()
        self.cursor.execute('CREATE TABLE [Reminders] ([uuid] TEXT NOT NULL PRIMARY KEY UNIQUE, [dateTime] DATETIME, [location] TEXT REFERENCES [Location](name) ON DELETE SET NULL, [todo] TEXT NOT NULL REFERENCES [Todo](uuid) ON DELETE SET NULL ON UPDATE CASCADE, [distance] INTEGER, [unit] INTEGER, [maemoID] INTEGER, [active] BOOLEAN);')
        self.db.commit()
        self.cursor.execute('CREATE TABLE [Preferences] ([sort_by] TEXT, [location] TEXT, [category] TEXT, [notCompleted_first] BOOLEAN, [show_completed] BOOLEAN, [id] INTEGER PRIMARY KEY ASC AUTOINCREMENT, [show_column_done] BOOLEAN, [show_column_title] BOOLEAN, [show_column_dueDate] BOOLEAN, [show_column_dueTime] BOOLEAN, [show_column_location] BOOLEAN, [show_column_reminder] BOOLEAN, [show_column_category] BOOLEAN, [portrait] INTEGER);')
        self.db.commit()
        self.cursor.execute("INSERT INTO Preferences (sort_by, location, category, notCompleted_first, show_completed, show_column_done, show_column_title, show_column_dueDate, show_column_dueTime, show_column_location, show_column_reminder, show_column_category, portrait) VALUES ('Title', 'NONE', 'NONE', 'True', 'True','True', 'True', 'True','True','False','False','False','0');")
        self.db.commit()
        self.cursor.execute('CREATE TABLE db_struct (version TEXT);')
        self.db.commit()
        self.cursor.execute('INSERT INTO db_struct (version) VALUES ("' + FRAMEWORK_VERSION + '");')
        self.db.commit()
        

#        def _update(self):
#            #RESERVED FOR FUTURE UPDATES ON THE DATABASE
#          self.cursor.execute('SELECT version From db_struct;')
#          for version in self.cursor.fetchall():
#            v, = version
#
#          if v < '0.0':
#            self._create()
#
#          if v < '0.2':
#            self.cursor.execute('ALTER TABLE todos ADD category TEXT')
#            self.db.commit()
#
#          self.cursor.execute('UPDATE db_struct SET version ="'+FRAMEWORK_VERSION+'";')
#          self.db.commit()


    def close(self):
        self.db.close()

    def loadPreferencesDB(self):
        db = Database(DB_PATH)                
        db.cursor.execute('SELECT * FROM Preferences where id=1')                
        results = db.cursor.fetchall()
        db.close()   
        return results[0]

    def savePreferencesDB(self, sort,location,category,notCompleted,show_completed,list_columns, portrait):
        db = Database(DB_PATH)
        list_insert = []
        list_insert.append(sort)
        list_insert.append(location)
        list_insert.append(category)
        list_insert.append(notCompleted)
        list_insert.append(show_completed)
        for column in list_columns:
            list_insert.append(column)
        list_insert.append(portrait)
        
        #INSERT INTO Preferences (sort_by, location, category, notCompleted_first, show_completed) VALUES ('title', 'NONE', 'NONE', 'True', 'True');
        db.cursor.execute('UPDATE Preferences SET sort_by=?, location=?, category=?, notCompleted_first=?, show_completed=?, show_column_done=?, show_column_title=?, show_column_dueDate=?, show_column_dueTime=?, show_column_location=?, show_column_reminder=?, show_column_category=?, portrait=? WHERE id=1;', list_insert)
        db.db.commit()
        db.close()
        
    def loadTodoDB(self, suuid):
        db = Database(DB_PATH)
        #db.cursor.execute('SELECT due_datetime, description, status, category FROM todos where uuid="'+suuid+'"')
        db.cursor.execute('SELECT * FROM Todo where uuid="' + suuid + '"')
        todo = Todo.Todo(suuid)
        #'CREATE TABLE [Todo] ([uuid] TEXT NOT NULL PRIMARY KEY UNIQUE, [title] TEXT, [description] TEXT, [dueDateTime] DATETIME, [completed] INTEGER, [priority] INTEGER, [category] TEXT, [location] TEXT REFERENCES [Location](uuid) ON DELETE SET NULL);')
        results = db.cursor.fetchall()
        if len(results) != 0:            
            for atributos in results:
                todo.title = atributos[1]                
                todo.description = atributos[2]
                if atributos[3] != 'NONE':
                    todo.dueDateTime = datetime.datetime.strptime(atributos[3], '%d-%m-%Y %H:%M')
                else:
                    todo.dueDateTime = 'NONE'                
                todo.completed = atributos[4]
                todo.priority = atributos[5]
                todo.category = atributos[6]
                
                if atributos[7] != 'NONE':
                    results = self.loadLocationDB(atributos[7])                                            
                    if len(results) != 0:
                        location = Location.Location(atributos[7])
                        for atributos_loca in results:
                            location.description= atributos_loca[1]
                            location.latitude = atributos_loca[2]                
                            location.longitude = atributos_loca[3]
                            location.zoomlevel = atributos_loca[4]
                    else: 
                        location = 'NONE'
                    todo.location = location                
        else:            
            sys.exit('ERROR YOU ARE TRYING TO RETRIEVE A TODO THAT DOES NOT EXIST IN THE DB')
        db.close()
        return todo


    def saveTodoDB(self, todo):
        db = Database(DB_PATH)        
        if todo.dueDateTime != 'NONE':
            try:
                dueDateTime = datetime.datetime.strftime(todo.dueDateTime, DB_FORMAT)
            except:
                dueDateTime = datetime.datetime.strptime(todo.dueDateTime, '%d-%m-%Y %H:%M')
                dueDateTime = datetime.datetime.strftime(todo.dueDateTime, DB_FORMAT)
        else:
            dueDateTime = 'NONE'
        db.cursor.execute('SELECT * FROM Todo where uuid="' + todo.uuid + '"')        
        if len(db.cursor.fetchall()) == 0:
            if todo.location != 'NONE':
                db.cursor.execute('INSERT INTO Todo (uuid , title, description, dueDateTime, completed, priority, category, location) VALUES(?,?,?,?,?,?,?,?);', [todo.uuid, todo.title, todo.description, dueDateTime, todo.completed, todo.priority, todo.category, todo.location.name])
            else:
                db.cursor.execute('INSERT INTO Todo (uuid , title, description, dueDateTime, completed, priority, category, location) VALUES(?,?,?,?,?,?,?,?);', [todo.uuid, todo.title, todo.description, dueDateTime, todo.completed, todo.priority, todo.category, todo.location])
        else:
            if todo.location != 'NONE':
                db.cursor.execute('UPDATE Todo SET title=?, description=?, dueDateTime=?, completed=?, priority=?, category=?, location=? WHERE uuid=?;', [todo.title, todo.description, dueDateTime, todo.completed, todo.priority, todo.category, todo.location.name, todo.uuid])
            else:
                db.cursor.execute('UPDATE Todo SET title=?, description=?, dueDateTime=?, completed=?, priority=?, category=?, location=? WHERE uuid=?;', [todo.title, todo.description, dueDateTime, todo.completed, todo.priority, todo.category, todo.location, todo.uuid])
        db.db.commit()

        db.close()

    def deleteTodoDB(self, todo):        
        db = Database(DB_PATH)
        db.cursor.execute('DELETE FROM Todo WHERE uuid ="' + todo.uuid + '";')
        db.db.commit()
        db.close()


    def loadLocationDB(self, name):
        db = Database(DB_PATH)                
        db.cursor.execute('SELECT * FROM Location where name="' + name+ '"')        
        #CREATE TABLE [Location] ([name] TEXT NOT NULL PRIMARY KEY UNIQUE, [description]  TEXT, [latitude] REAL, [longitude] REAL);')
        results = db.cursor.fetchall()
        db.close()        
        return results

    def saveLocationDB(self, location):
        db = Database(DB_PATH)
        db.cursor.execute('SELECT * FROM Location where name="' + location.name + '"')

        if len(db.cursor.fetchall()) == 0:
            #It's a new entry so INSERT
            db.cursor.execute('INSERT INTO Location (name, description, latitude, longitude, zoomlevel) VALUES(?,?,?,?,?);', [location.name, location.description, location.latitude, location.longitude, location.zoomlevel])
        else:
            #It's an existing ENTRY so UPDATE
            db.cursor.execute('UPDATE Location SET description=?, latitude=?, longitude=?, zoomlevel=? WHERE name=?;', [location.description, location.latitude, location.longitude,location.zoomlevel, location.name])
        db.db.commit()
        db.close()

    def deleteLocationDB(self, location_name):
        db = Database(DB_PATH)
        db.cursor.execute('DELETE FROM Location WHERE name ="' + location_name + '";')
        db.db.commit()
        db.close()


    def loadRemindernDB(self, uuid):
        db = Database(DB_PATH)            
        #db.cursor.execute('SELECT * FROM Todo where uuid="' + suuid + '"')
        db.cursor.execute('SELECT * FROM Reminders where uuid="' + uuid + '"')        
        reminder= Reminder.Reminder('',uuid)
        results = db.cursor.fetchall()                
        if len(results) != 0:            
            #CREATE TABLE [Reminders] ([uuid] TEXT NOT NULL PRIMARY KEY UNIQUE, [dateTime] DATETIME, [location] TEXT REFERENCES [Location](name) ON DELETE SET NULL, [todo] TEXT NOT NULL REFERENCES [Todo](uuid) ON DELETE SET NULL ON UPDATE CASCADE, [distance] INTEGER, [unit] INTEGER)')
            for atributos in results:                            
                if atributos[1] != 'NONE':                                    
                    reminder.dateTime = datetime.datetime.strptime(atributos[1], '%d-%m-%Y %H:%M')                    
                else:
                    reminder.dateTime = 'NONE'
                if atributos[2] != 'NONE':
                    #TODO ADICIONAR CONTROLE SE LOCATION NAO EXISTIR MAIS                    
                    results = self.loadLocationDB(atributos[2])                                            
                    if len(results) != 0:
                        location = Location.Location(atributos[2])
                        for atributos_loca in results:
                            location.description= atributos_loca[1]
                            location.latitude = atributos_loca[2]                
                            location.longitude = atributos_loca[3]
                            location.zoomlevel = atributos_loca[4]
                    else: 
                        location = 'NONE'
                    reminder.location = location                
                else:
                    reminder.location = 'NONE'
                reminder.todo = self.loadTodoDB(atributos[3])
                reminder.distance = atributos[4]
                reminder.unit = atributos[5]
                reminder.maemoID = atributos[6]
                reminder.active = atributos[7]
        else:
            sys.exit('ERROR YOU ARE TRYING TO RETRIEVE A REMINDER THAT DOES NOT EXIST IN THE DB')
        db.close()
        return reminder

    def saveReminderDB(self, reminder):
        db = Database(DB_PATH)
        dateTime = 'NONE'
        if reminder.dateTime != 'NONE':
            try:
                dateTime = datetime.datetime.strftime(reminder.dateTime, DB_FORMAT)
            except:
                dateTime = datetime.datetime.strptime(reminder.dateTime, '%d-%m-%Y %H:%M')
                dateTime = datetime.datetime.strftime(reminder.dateTime, DB_FORMAT)
        db.cursor.execute('SELECT * FROM Reminders where uuid="' + reminder.uuid + '"')
        if len(db.cursor.fetchall()) == 0:
            #It's a new entry so INSERT
            if reminder.location != 'NONE':
                #Means it is a reminder by location
                db.cursor.execute('INSERT INTO Reminders (uuid, dateTime, location, todo, distance, unit,maemoID, active) VALUES(?,?,?,?,?,?,?,?);', [reminder.uuid, dateTime, reminder.location.name, reminder.todo.uuid,reminder.distance,reminder.unit,reminder.maemoID,reminder.active])
            else:
                db.cursor.execute('INSERT INTO Reminders (uuid, dateTime, location, todo, distance, unit, maemoID, active) VALUES(?,?,?,?,?,?,?,?);', [reminder.uuid, dateTime, reminder.location, reminder.todo.uuid,reminder.distance,reminder.unit,reminder.maemoID,reminder.active])
        else:
            #It's an existing ENTRY so UPDATE
            if reminder.location != 'NONE':
                db.cursor.execute('UPDATE Reminders SET dateTime=?, location=?, todo=?, distance=?, unit=?, maemoID=?, active=? WHERE uuid=?;;', [dateTime, reminder.location.name, reminder.todo.uuid,reminder.distance,reminder.unit, reminder.maemoID, reminder.uuid,reminder.active])
            else:
                db.cursor.execute('UPDATE Reminders SET dateTime=?, location=?, todo=?, distance=?, unit=?, maemoID=?, active=? WHERE uuid=?;;', [dateTime, reminder.location, reminder.todo.uuid,reminder.distance,reminder.unit,reminder.maemoID, reminder.uuid,reminder.active])
        db.db.commit()
        db.close()

    def deleteReminderDB(self, reminder_uuid):
        db = Database(DB_PATH)
        db.cursor.execute('DELETE FROM Reminders WHERE uuid ="' + reminder_uuid+ '";')
        db.db.commit()
        db.close()

    def get_categories(self):
        db = Database(DB_PATH)
        categories = []
        categories.append('All')        
        query = 'SELECT DISTINCT category FROM Todo;'
        db.cursor.execute(query)
        for cat in db.cursor.fetchall():            
            if cat[0] != 'NONE':
                categories.append(cat[0])
        return categories

    def get_locations(self):
        db = Database(DB_PATH)
        locations = []
        locations.append('All')
        query = 'SELECT name FROM Location;'
        db.cursor.execute(query)
        for cat in db.cursor.fetchall():
            if cat[0]!=None:
                if cat[0]!='NONE':
                    locations.append(cat[0])
        return locations
    
    def get_reminders(self):
        db = Database(DB_PATH)
        reminders = []        
        query = 'SELECT uuid FROM Reminders;'
        db.cursor.execute(query)
        for cat in db.cursor.fetchall():
            if cat[0]!= None:
                reminders.append(cat[0])
        return reminders

    def get_todos(self):
        db = Database(DB_PATH)
        todos_list = []
        query = 'SELECT uuid FROM Todo'
        db.cursor.execute(query)
        for uuid in db.cursor.fetchall():              
            todo =self.loadTodoDB(uuid[0])
            todos_list.append(todo)
        return todos_list
    
    def get_reminders_from_Todo(self, uuidTodo):
        db = Database(DB_PATH)
        all_reminders = []        
        db.cursor.execute('SELECT uuid FROM Reminders where todo="' + uuidTodo+ '"')        
        results = db.cursor.fetchall()
        if len(results) != 0:
            for reminder in results:
                all_reminders.append(reminder[0])        
        db.close()
        return all_reminders