#include "mainwidget.h"

#include <QMenuBar>
#include <QApplication>
#include <QDesktopWidget>
#include <QScrollArea>
#include <QLayout>
#include <QLocale>
#include <QTranslator>

MainWidget::MainWidget(QWidget *parent) :
    QScrollArea(parent)
{
#if defined(Q_OS_WINCE) || defined(Q_OS_SYMBIAN)
    setGeometry(QApplication::desktop()->availableGeometry(0));
    setWindowState(windowState() | Qt::WindowMaximized);
#else
    setGeometry(QRect(10,10,400,480));
#endif
    setFrameShape(QFrame::NoFrame);

    setWindowIcon(QIcon(":/img/bookcase.png"));
    setWindowTitle("G-Speed Reader");

    if (QLocale::system().language()==QLocale::Russian){
        QTranslator *translator = new QTranslator;
        translator->load(":/russian.qm");
        qApp->installTranslator(translator);
    }

    wgtStart = new StartWidget;
    wgtEditor = new EditorWidget;
    wgtExercise = new ExerciseWidget;
    wgtAbout = new AboutBox;
    wgtLastActive = wgtStart;

    QMenuBar *mainMenu=new QMenuBar;

#if defined(Q_OS_WINCE) || defined(Q_WS_HILDON) || defined(Q_OS_SYMBIAN)
    connect(mainMenu->addAction(tr("&New exercise")),SIGNAL(triggered()),this,SLOT(showStartWidget()));
    connect(mainMenu->addAction(tr("&Exit")),SIGNAL(triggered()),this,SLOT(close()));
#else
    QMenu *menu = mainMenu->addMenu(tr("&File"));
    connect(menu->addAction(tr("&New exercise")),SIGNAL(triggered()),this,SLOT(showStartWidget()));
    connect(menu->addAction(tr("&Exit")),SIGNAL(triggered()),this,SLOT(close()));
#endif

    connect(mainMenu->addAction(tr("&About")),SIGNAL(triggered()),this,SLOT(showAboutBox()));
    stackedLayout.setMenuBar(mainMenu);

    stackedLayout.addWidget(wgtStart);
    stackedLayout.addWidget(wgtExercise);
    stackedLayout.addWidget(wgtEditor);
    stackedLayout.addWidget(wgtAbout);

    setLayout(&stackedLayout);

    connect(wgtStart,SIGNAL(exercise(int)),this,SLOT(showExerciseWidget(int)));
    connect(wgtExercise,SIGNAL(showEditor()),this,SLOT(showEditorWidget()));
    connect(wgtEditor,SIGNAL(done(bool)),this,SLOT(setExerciseText(bool)));
    connect(wgtExercise,SIGNAL(gotoStart()),this,SLOT(showStartWidget()));
    connect(wgtExercise,SIGNAL(exerciseChanged(bool)),this,SLOT(setExerciseText(bool)));
    connect(wgtAbout,SIGNAL(hidden()),this,SLOT(showLastActiveWidget()));
}

void MainWidget::showExerciseWidget(int mode){
    wgtLastActive = wgtExercise;
    stackedLayout.setCurrentWidget(wgtExercise);
    wgtExercise->selectExercise(mode);
}

void MainWidget::showEditorWidget(){
    wgtLastActive = wgtEditor;
    stackedLayout.setCurrentWidget(wgtEditor);
}

void MainWidget::showStartWidget(){
    wgtLastActive = wgtStart;
    stackedLayout.setCurrentWidget(wgtStart);
}

void MainWidget::setExerciseText(bool b){
    wgtLastActive = wgtExercise;
    stackedLayout.setCurrentWidget(wgtExercise);
    if (b)
        wgtExercise->setText(wgtEditor->getText());
}

void MainWidget::showAboutBox(){
    stackedLayout.setCurrentWidget(wgtAbout);
}

void MainWidget::showLastActiveWidget(){
    stackedLayout.setCurrentWidget(wgtLastActive);
}
