#ifndef EXERCISERAPID_H
#define EXERCISERAPID_H

#include "exercise.h"

#include <QLabel>
#include <QTimer>

struct ExerciseRapidSettings {
    int wordsOnScreen;
    int lineNumbers;
    int minSpeed;
    int maxSpeed;
    bool accelerate;
    ExerciseRapidSettings(): wordsOnScreen(1),lineNumbers(1),minSpeed(60),maxSpeed(300),accelerate(false) {};
};

class ExerciseRapid : public Exercise
{
Q_OBJECT
public:
    ExerciseRapid(QWidget *parent = 0);
    QWidget* settingsWidget();
    bool advancedMode();
    void setText(QString&);
    void showExerciseInfo();
    bool isEmptyText();
    bool isActive();
    int maxProgress();
    int speed();
    int mode();
protected:
    void mousePressEvent(QMouseEvent *);
    void resizeEvent(QResizeEvent *);

public slots:
    void start();
    void stop();
    void tick();
    void zoomIn();
    void zoomOut();
    void faster();
    void slower();
    void pause();
    void setOffset(int);

private slots:
    void setWordsOnScreen(int);
    void setLinesNumber(int);
    void setMinSpeed(int);
    void setMaxSpeed(int);
    void setAccelerate(bool);

private:
    void generateSettings();

    QWidget m_settingsWidget;
    QLabel m_lblText;
    QStringList m_strList;
    int m_currentPos;
    QLabel m_lblExerciseInfo;
    int m_interval;
    ExerciseRapidSettings m_settings;
    QTimer m_timer;    
    QLabel m_lblPause;
};

#endif // EXERCISERAPID_H
