#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include "exercisewidget.h"
#include "startwidget.h"
#include "editorwidget.h"
#include "aboutbox.h"

#include <QScrollArea>
#include <QStackedLayout>

class MainWidget : public QScrollArea
{
Q_OBJECT
public:
    explicit MainWidget(QWidget *parent = 0);

public slots:
    void showExerciseWidget(int);
    void showEditorWidget();
    void showStartWidget();
    void showAboutBox();
    void showLastActiveWidget();
    void setExerciseText(bool);

private:
    EditorWidget* wgtEditor;
    ExerciseWidget* wgtExercise;
    StartWidget* wgtStart;
    AboutBox* wgtAbout;
    QWidget *wgtLastActive;

    QStackedLayout stackedLayout;
};

#endif // MAINWIDGET_H
