#include "exercisenumbers.h"

#include <QVBoxLayout>
#include <QFont>
#include <QPushButton>

ExerciseNumbers::ExerciseNumbers(QWidget *parent) :
        Exercise(parent)
{
    QVBoxLayout *vbLayout = new QVBoxLayout;

    m_shulte.setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);

    m_lblExerciseInfo.setSizePolicy(QSizePolicy::Preferred,QSizePolicy::MinimumExpanding);
    m_lblExerciseInfo.setGeometry(geometry());
    m_lblExerciseInfo.setAlignment(Qt::AlignJustify|Qt::AlignTop);
    m_lblExerciseInfo.setWordWrap(true);

    vbLayout->addWidget(&m_shulte);
    vbLayout->addWidget(&m_lblExerciseInfo);

    setLayout(vbLayout);

    showExerciseInfo();

    generateSettings();

    m_activeState = false;
}

void ExerciseNumbers::showExerciseInfo(){
    m_shulte.hide();

    QString info = tr("\tShulte table allow you to see a lot of text at one time.");

    m_lblExerciseInfo.setText(info);

    m_lblExerciseInfo.show();
}

QWidget* ExerciseNumbers::settingsWidget(){
    return &m_settingsWidget;
}

bool ExerciseNumbers::advancedMode(){
    return false;
}

void ExerciseNumbers::start(){
    m_lblExerciseInfo.hide();
    m_shulte.generateNew();
    m_shulte.show();
    m_activeState = true;
}

void ExerciseNumbers::stop(){
    showExerciseInfo();
    m_activeState = false;
}

void ExerciseNumbers::pause(){
    showExerciseInfo();
    m_activeState = false;
}

void ExerciseNumbers::zoomIn(){
    QFont font(m_shulte.font());
    int i=font.pointSize();
    if (i<24) {
        font.setPointSize(++i);

        m_shulte.setFont(font);
//        m_lblExerciseInfo.setFont(font);
        emit minZoomExceed(false);
        if (i>=24)
            emit maxZoomExceed(true);
    } else
        emit maxZoomExceed(true);
}

void ExerciseNumbers::zoomOut(){
    QFont font(m_shulte.font());
    int i=font.pointSize();
    if (i>8){
        font.setPointSize(--i);

        m_shulte.setFont(font);
//        m_lblExerciseInfo.setFont(font);
        emit maxZoomExceed(false);
        if (i<=8)
            emit minZoomExceed(true);
    } else
        emit minZoomExceed(true);
}

void ExerciseNumbers::mousePressEvent(QMouseEvent *){
    emit clicked();
}

void ExerciseNumbers::generateSettings(){
    m_settingsWidget.setAutoFillBackground(true);

    QVBoxLayout *vbLayout = new QVBoxLayout;

    QLabel *lbl = new QLabel("<b>"+tr("Settings of Rapid exercise")+"</b>");

    vbLayout->addWidget(lbl);

    vbLayout->addStretch();
    QPushButton *btn = new QPushButton(tr("OK"));
    btn->setIcon(QIcon::fromTheme("window-close", QIcon(":/img/ok.png")));
    connect(btn,SIGNAL(clicked()),&m_settingsWidget,SLOT(hide()));

    vbLayout->addWidget(btn);

    m_settingsWidget.setLayout(vbLayout);
}

void ExerciseNumbers::resizeEvent(QResizeEvent *event){
    QWidget::resizeEvent(event);
    if (parent()!=NULL){
        QSize s=parentWidget()->size();
        m_settingsWidget.setGeometry(0,0,s.width(),s.height());
    }
}

bool ExerciseNumbers::isActive(){
    return m_activeState;
}

int ExerciseNumbers::mode(){
    return Exercise::Shulte;
}
