/* 
 * This file is part of fuelpad, the fuel diary
 *
 * Copyright (c) 2007-2010 Julius Luukko <julle.luukko@quicknet.inet.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <sqlite3.h>
#include <stdlib.h>
#include <location/location-gps-device.h>
#include <location/location-distance-utils.h>
#include "dbextension.h"

/*******************************************************************
 *
 * Private defines
 *
 *******************************************************************/

/*******************************************************************
 *
 * Public variables
 *
 *******************************************************************/

/*******************************************************************
 *
 * Private function prototypes
 *
 *******************************************************************/

/*******************************************************************
 *
 * Private functions
 *
 *******************************************************************/

static
void circleDistanceFunc(sqlite3_context *context, int argc, sqlite3_value **argv)
{
  double lat_s;
  double lon_s;
  double lat_f;
  double lon_f;
  double distance;

  if (argc<4) {
    sqlite3_result_double(context, 0.0);
    return;
  }

  /* Starting latitude */
  switch( sqlite3_value_type(argv[0]) ){
    case SQLITE_INTEGER: {
      lat_s = (double)sqlite3_value_int64(argv[0]);
      break;
    }
    default: {
      lat_s = sqlite3_value_double(argv[0]);
      break;
    }
  }

  /* Starting longitude */
  switch( sqlite3_value_type(argv[1]) ){
    case SQLITE_INTEGER: {
      lon_s = sqlite3_value_int64(argv[1]);
      break;
    }
    case SQLITE_NULL: {
      sqlite3_result_null(context);
      break;
    }
    default: {
      lon_s = sqlite3_value_int64(argv[1]);
      break;
    }
  }

  /* Final latitude */
  switch( sqlite3_value_type(argv[2]) ){
    case SQLITE_INTEGER: {
      lat_f = (double)sqlite3_value_int64(argv[2]);
      break;
    }
    default: {
      lat_f = sqlite3_value_double(argv[2]);
      break;
    }
  }

  /* Starting longitude */
  switch( sqlite3_value_type(argv[3]) ){
    case SQLITE_INTEGER: {
      lon_f = sqlite3_value_int64(argv[3]);
      break;
    }
    case SQLITE_NULL: {
      sqlite3_result_null(context);
      break;
    }
    default: {
      lon_f = sqlite3_value_int64(argv[3]);
      break;
    }
  }

  distance = 1000.0*location_distance_between(lat_s, lon_s, lat_f, lon_f);
  sqlite3_result_double(context, distance);

}

/*******************************************************************
 *
 * Public functions
 *
 *******************************************************************/

void db_extensions_add(sqlite3 *db)
{
  sqlite3_create_function(db, "circdist", 4, SQLITE_UTF8, NULL,
			  &circleDistanceFunc, NULL, NULL);
}
