#!/usr/bin/env python2.5

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# ============================================================================
# Name        : fschedule.py
# Author      : nux@mpde.ee
# Version     : 0.1
# Description : Show cinema schedule on FC Estonia/Latvia/Lithuania cinemas.
# ============================================================================

import gtk
import hildon
import time
import urllib
import threading
import thread
import osso
import sys, string
import ConfigParser

from xml.dom import minidom, Node

#Connect to osso service
ctx = osso.Context('fSchedule', '0.1', False)

gtk.gdk.threads_init()

class MovieWindow(hildon.StackableWindow):
    def __init__(self, url, id):
        gtk.Window.__init__(self)
        self.connect("delete_event", self.close_window)
        self.localtitle = ""
        self.productionyear = ""
        self.ratingname = ""
        self.genre = ""
        self.annotation = ""
        self.productioncompany = ""
        self.length = ""
        self.distributiorcompany = ""
        self.imageurl = ""
        self.image = gtk.Image()
        self.exiting = False

        #Make pannable area with vbox (we add later hbox into it)
        self.vbox = gtk.VBox()
        pa = hildon.PannableArea()
        pa.add_with_viewport(self.vbox)
        self.add(pa)
        #Showing window
        self.show_all()
                        
        #set hourglass running
        hildon.hildon_gtk_window_set_progress_indicator(self, 1) 
        #Start get details thread
        self.bthread = threading.Thread(target=self.do_all, args=(url,id,))
        self.bthread.start()
        #create get image thread so we can stop it later
        self.ithread = threading.Thread(target=self.get_image, args=("None",))

    def close_window(self, widget, event, data=None):
        #terminating threads and waiting them to finish
        self.exiting = True
        #print 'exit details window'
        #print self.bthread.isAlive()
        if (self.bthread.isAlive()):
            self.bthread.join(2)
        #print self.ithread.isAlive()
        if (self.ithread.isAlive()):
            self.ithread.join(2)
        #print 'stopped threads success'

    def do_all(self, *args):
        try:
            self.get_details(args)
            self.draw_data(args)
            
            #Show all that we have drawn if not exiting
            if (self.exiting):
                return
            else:    
                self.show_all()
            
            #Start get image thread
            self.ithread.start()
        except Exception, e:
            print 'Error: %s' % (str(e))
            #Create a banner with a markup
            #banner = hildon.hildon_banner_show_information(self, "None", str(e))

    def get_image(self, args):
        #Get the image from web also
        f = urllib.urlopen(self.imageurl)
        s = f.read()
        f.close()
        #If exiting then stop showing the image
        if (self.exiting): return
        if (s.find('HTML') < 0):   
            try:
                ext = self.imageurl[self.imageurl.rfind('.')+1:len(self.imageurl)]
                if (ext == 'jpg'): ext = 'jpeg'
                loader = gtk.gdk.PixbufLoader(ext)        
                loader.write(s)
                loader.close()
                pixbuf = loader.get_pixbuf()
                self.image.set_from_pixbuf(pixbuf) 
            except Exception, e:
                #print 'Error: %s' % (str(e))        
                #Create a banner with a markup
                banner = hildon.hildon_banner_show_information(self, "None", str(e))        
        #Stop hourglass
        hildon.hildon_gtk_window_set_progress_indicator(self, 0)
        self.show_all()
        
    def draw_data(self, args):
        labeltitle = gtk.Label(self.localtitle)
        labelrating = gtk.Label(self.ratingname)
        labelgenre = gtk.Label(self.genre)
        labelyear = gtk.Label('Production Year: %s' % (self.productionyear))
        labellength = gtk.Label('Length in minutes: %s' % (self.length))
        labelprod = gtk.Label('Production Company: %s' % (self.productioncompany))
        labeldist = gtk.Label('Local distributor: %s' % (self.distributiorcompany))
        labelannotation = gtk.Label()
        labelannotation.set_text(self.annotation)
        labelannotation.set_line_wrap(True)        

        self.vbox.pack_start(labeltitle)        
        self.vbox.pack_start(labelrating)        
        self.vbox.pack_start(labelgenre)        
        
        #Vbox that holds year and length
        vbox_left = gtk.VBox()
        vbox_left.pack_start(labelyear)
        vbox_left.pack_start(labellength)

        #Make horizontal box where each button takes as much space it needs by default
        #gtk.HBox(homogeneous=False, spacing=0) If True all children are given equal space allocations.
        hbox = gtk.HBox(False, 0)
        #def pack_start(child, expand=True, fill=True, padding=0)
        hbox.pack_start(vbox_left, 0, 0)
        hbox.pack_start(self.image, 1, 1)
        self.vbox.pack_start(hbox)
        #Put hbox into our vbox we have inside pannable area
        self.vbox.pack_start(labelprod)
        self.vbox.pack_start(labeldist)
        self.vbox.pack_start(gtk.Label('')) #empty line between annotation
        self.vbox.pack_start(labelannotation)
                
    def get_details(self, args):
        #print 'Downloading %s' % (args[0])
        #Download schedule xml        
        f = urllib.urlopen(args[0])
        xml = f.read()
        f.close()
        #hack for remembering movieid
        mid = 0
        #Parse xml into list
        doc = minidom.parseString(xml)
        rootNode = doc.documentElement
        for node in self.walkTree(rootNode):
            if (node.nodeName == "movieId"):
                mid = self.get_xml_content(node)
            if (mid == args[1]):
                self.collectNodes(node)
        #print 'get_xml done'
                        
    def walkTree(self, node):
		if node.nodeType == Node.ELEMENT_NODE:
			yield node
			for child in node.childNodes:
				for n1 in self.walkTree(child):
					yield n1
    
    def clean_annotation(self):
        orig = self.annotation
        while True:
            i = orig.find('<object')
            #print i
            if (i < 0): break
            temp_up = orig[0:i]
            j = orig.find('</object>')+10
            #print j
            #print len(orig)
            if (j > len(orig)): j = len(orig)
            temp_down = orig[j:len(orig)]
            orig = temp_up + temp_down
        self.annotation = orig    
    
    def collectNodes(self, node):
        if (node.nodeName == "title"):
            self.localtitle = self.get_xml_content(node)
        if (node.nodeName == "ratingName"):
            self.ratingname = self.get_xml_content(node)
        if (node.nodeName == "genre"):
            self.genre = self.get_xml_content(node)
        if (node.nodeName == "annotation"):
            self.annotation = self.get_xml_content(node)
            self.clean_annotation()
        if (node.nodeName == "productionCompany"):
            self.productioncompany = self.get_xml_content(node)
        if (node.nodeName == "distributor"):
            self.distributiorcompany = self.get_xml_content(node)
        if (node.nodeName == "length"):
            self.length = self.get_xml_content(node)
        if (node.nodeName == "productionYear"):
            self.productionyear = self.get_xml_content(node)
        if (node.nodeName == "imageType1"):
            self.imageurl = self.get_xml_content(node)
                    
    def get_xml_content(self, node):
        content = []
        for child in node.childNodes:
            if child.nodeType == Node.TEXT_NODE:
                content.append(child.nodeValue)
        strContent = string.join(content)
        return strContent                              

class Window(hildon.StackableWindow):
    def __init__(self, url, id):
        gtk.Window.__init__(self)        
        self.connect("delete_event", self.close_window)
        self.url = url
        self.theatreid = id
        self.showtime = []
        self.originalname = []
        self.auditorium = []
        self.ratingurl = []
        self.ratingimages = []
        self.showlink = []
        self.movieid = []
        self.scheduledate = ''
        self.exiting = False
        #pointer to last beginning show button
        self.pointer_show = None

        #Showing empty window for user
        self.show_all()
        
        #Make pannable area with vbox (we add later hbox into it)
        self.pa = hildon.PannableArea()
        self.pa.set_property("mov-mode", hildon.MOVEMENT_MODE_BOTH)
        #We use callback to scroll pannable area after maping (not working right now)
        self.pa.connect_after('map', self.on_map)
        self.vbox = gtk.VBox()
        self.vbox.show()
        
        self.pa.add_with_viewport(self.vbox)
        self.add(self.pa)
                
        #set hourglass running
        hildon.hildon_gtk_window_set_progress_indicator(self, 1) 
        #Start get schedule thread
        target = '%sschedule/?theatreId=%s' % (self.url, self.theatreid)
        self.bthread = threading.Thread(target=self.do_all, args=(target,))
        self.bthread.start()
        #create rating thread so we can stop it when exiting 
        self.rthread = threading.Thread(target=self.get_ratings_thread, args="None")

    def on_map(self, pannable_area):
        #print 'started scrolling'
        #print 'pa ', self.pa.flags()
        #print 'button ', self.pointer_show.flags()
        #Scroll to next show
        pannable_area.scroll_to_child(self.pointer_show)
        #print 'scrolled'
        
    def scroll_to(self, button):
        #print 'scroll_to'
        self.on_map(self.pa)
        
    def close_window(self, widget, event, data=None):
        #terminating threads and waiting them to finish
        self.exiting = True
        #print 'exit schedule window'
        #print self.bthread.isAlive()
        if (self.bthread.isAlive()):
            self.bthread.join(2)
        #print self.rthread.isAlive()
        if (self.rthread.isAlive()):
            self.rthread.join(2)
        #print 'stopped threads success'

    def btn_movie_clicked(self, button, args):
        target = '%smovies/?movieId=%s' % (self.url, args[0])
        self.win = MovieWindow(target, args[0])
        self.win.set_title(self.originalname[args[1]])
        #Create a banner with a markup
        banner = hildon.hildon_banner_show_information(self.win, "None", "Downloading Movie details")

    def open_url(self, button, data):
        osso_rpc = osso.Rpc(ctx)
        osso_rpc.rpc_run("com.nokia.osso_browser","/com/nokia/osso_browser/request", 'com.nokia.osso_browser','load_url',rpc_args=(str(data),))

    def do_all(self, *args):
        try:
            self.get_schedule(args)
            #level up auditorium names
            #self.equal_aud_names(args)
            #fill empty ratings
            for item in self.ratingurl:
                self.ratingimages.append(gtk.Image())
            #print 'before drawing'
            self.draw_schedule(args)
            #Show all that we have drawn
            #print 'after drawing and before show all'
            #If we are closing window then abort
            if (self.exiting): 
                return
            else:    
                self.show_all()
            #print 'now starting ratings thread'
            #Start get raitings thread so we can show schedule earlyer
            self.rthread.start()
        except Exception, e:
            print 'Error: %s' % (str(e))
            #Create a banner with a markup
            #hildon.hildon_gtk_window_set_progress_indicator(self, 0)
            #banner = hildon.hildon_banner_show_information(self, "None", str(e))

    def get_ratings_thread(self, *args):
        self.get_ratings(args)        
        #Stop hourglass
        hildon.hildon_gtk_window_set_progress_indicator(self, 0)
        #Show all again
        #self.show_all()

    def equal_aud_names(self, args):
        maxwidth = 0
        for item in self.auditorium:
            if len(item) > maxwidth:
                maxwidth = len(item)
        #print maxwidth
        for index, item in enumerate(self.auditorium):
            temp = item.rjust(len(item) + 1)
            temp = temp.ljust(maxwidth + (maxwidth - len(item)))
            self.auditorium[index] = temp
            #print '%s - %d - %d' % (temp, len(temp), len(item))
        
    def draw_schedule(self, args):
        #print "drawing buttons"
        vbox_left = gtk.VBox()
        vbox_right = gtk.VBox()
        #lbl_header = gtk.Label("Schedule for date " + self.scheduledate + " (fetched: " + time.strftime("%a, %d %b %Y %H:%M:%S", time.localtime()) + ")")
        lbl_butt = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        lbl_butt.set_text("Schedule for date " + self.scheduledate + " (fetched: " + time.strftime("%a, %d %b %Y %H:%M:%S", time.localtime()) + ")", "Press here for scrolling to current time")
        lbl_butt.connect("clicked", self.scroll_to)
        #lbl_butt.set_alignment(.5, .5, .5, .5)
        lbl_butt.set_value_alignment(.5, 1)
        self.pointer_show = lbl_butt
        
        self.vbox.pack_start(lbl_butt)
        #self.vbox.pack_start(lbl_header)
        for index, item in enumerate(self.originalname):
             #If we are closing window then abort
             if (self.exiting): break
                              
             butt_title = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
             butt_title.set_text(item, "")
             butt_title.connect("clicked", self.btn_movie_clicked, [self.movieid[index], index])
             #butt_title.set_sensitive(1)
             
             butt_time = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
             butt_time.set_text(self.showtime[index], "")
             butt_time.connect("clicked", self.open_url, self.showlink[index])
             #butt_time.set_sensitive(1)
             #Save last started show to pointer
             if (self.showtime[index] < time.strftime("%H:%M", time.localtime())): 
                 self.pointer_show = butt_time
                 #print "%s" % (self.showtime[index])

             #butt_rating = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
             #butt_rating.add(self.ratingimages[index])
             #butt_rating.set_sensitive(1)
             
             #butt_hall = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
             #butt_hall.set_text(self.auditorium[index], "")
             #butt_hall.set_sensitive(1)
             lbl_hall = gtk.Label(self.auditorium[index])

             #Make horizontal box where each button takes as much space it needs by default
             #gtk.HBox(homogeneous=False, spacing=0) If True all children are given equal space allocations.
             hbox = gtk.HBox(False, 0)
             #def pack_start(child, expand=True, fill=True, padding=0)
             hbox.pack_start(butt_time, 0, 0) #put time to hbox
             hbox.pack_start(self.ratingimages[index], 0, 0) #put raiting to hbox
             hbox.pack_start(lbl_hall, 0, 0) #put hall to hbox
             #put hbox to left vbox
             vbox_left.pack_start(hbox)             
             vbox_right.pack_start(butt_title, 1, 1)
        hbox_all = gtk.HBox(False, 0)
        hbox_all.pack_start(vbox_left, 0, 0) #put left block
        hbox_all.pack_start(vbox_right, 1, 1) #put right block         
        self.vbox.pack_start(hbox_all)
        #self.vbox.show_all()
        #self.show()

    def get_schedule(self, args):
        #print 'Downloading %s' % (args[0])
        #Download schedule xml        
        f = urllib.urlopen(args[0])
        xml = f.read()
        f.close()
        
        #Parse xml into list
        doc = minidom.parseString(xml)
        rootNode = doc.documentElement
        for node in self.walkTree(rootNode):
            self.collectNodes(node)
        #print 'get_schedule done'

    def get_ratings(self, args):
        #print 'get_ratings started'
        try:
            for index, item in enumerate(self.ratingurl):
                #If we are closing window then abort
                if (self.exiting): break
                #Download each picture only once, so looking if we already have it
                i = self.ratingurl.index(item)
                #sys.stdout.write('Current: %u Found: %u\n' % (index, i))
                if (i == index):
                    #Get picture from web
                    f = urllib.urlopen(item)
                    s = f.read()
                    f.close() 
                    #Assign it through pixbuf to image and then to list if it is not error
                    if (s.find('HTML') < 0):
                        ext = item[item.rfind('.')+1:len(item)]
                        if (ext == 'jpg'): ext = 'jpeg'
                        loader = gtk.gdk.PixbufLoader(ext)        
                        loader.write(s)
                        loader.close()
                        pixbuf = loader.get_pixbuf()
                        self.ratingimages[index].set_from_pixbuf(pixbuf)
                    #image = gtk.Image()
                    #image.set_from_pixbuf(pixbuf)
                    #self.ratingimages.append(image)
                else:
                    #Take picture from list
                    self.ratingimages[index].set_from_pixbuf(self.ratingimages[i].get_pixbuf())
                    #image = gtk.Image()
                    #image.set_from_pixbuf(self.ratingimages[i].get_pixbuf())
                    #self.ratingimages.append(image)
                #self.show_all()
                self.ratingimages[index].show()    
        except Exception, e:
            print '%s\nError: %s' % (item,str(e))
            #Create a banner with a markup
            hildon.hildon_gtk_window_set_progress_indicator(self, 0)
            banner = hildon.hildon_banner_show_information(self, "None", str(e))        
        #print 'get_ratings done'         
        
    def walkTree(self, node):
		if node.nodeType == Node.ELEMENT_NODE:
			yield node
			for child in node.childNodes:
				for n1 in self.walkTree(child):
					yield n1
    
    def collectNodes(self, node):
        if (node.nodeName == "showDateTime"):
            self.showtime.append(self.get_xml_content(node)[11:16])
            self.scheduledate = self.get_xml_content(node)[0:10]
        if (node.nodeName == "hall"):
            self.auditorium.append(self.get_xml_content(node))
        if (node.nodeName == "originalTitle"):
            self.originalname.append(self.get_xml_content(node))
        if (node.nodeName == "ratingIcon"):
            self.ratingurl.append(self.get_xml_content(node))
        if (node.nodeName == "showLink"):
            self.showlink.append(self.get_xml_content(node))
        if (node.nodeName == "movieId"):
            self.movieid.append(self.get_xml_content(node)) 

    def get_xml_content(self, node):
        content = []
        for child in node.childNodes:
            if child.nodeType == Node.TEXT_NODE:
                content.append(child.nodeValue)
        strContent = string.join(content)
        return strContent                              
		
class MainWindow(hildon.StackableWindow):
    def __init__(self):
        gtk.Window.__init__(self)
        self.connect('destroy', gtk.main_quit)
        self.set_title("fSchedule")
        self.cinemas = []
        self.sites = ['http://www.forumcinemas.ee/rss/xml/', 'http://www.forumcinemas.lv/rss/xml/', 'http://www.forumcinemas.lt/rss/xml/', 'http://www.finnkino.fi/rss/xml/']
        self.sitenames = ['Forum Cinema Estonia', 'Forum Cinema Latvia', 'Forum Cinema Lithuania', 'Finnkino Finland']
        self.defaultsite = 0
        self.currentsite = 0
        self.read_config()
        
        #Make pannable area with vbox (we add later buttons into it)
        self.vbox = gtk.VBox()
        pa = hildon.PannableArea()
        pa.add_with_viewport(self.vbox)
        self.add(pa)
        # create a menu object by calling a method to define it
        self.menu = self.create_m5_menu(self)
        # Attach menu to the window
        self.set_app_menu(self.menu)

        #Showing window
        self.show_all()
        self.start_thread()       

    def start_thread(self):
        #Create a banner with a markup
        banner = hildon.hildon_banner_show_information(self, "None", "Downloading Cinemas list")
        banner.set_timeout(3000)
        #set hourglass running
        hildon.hildon_gtk_window_set_progress_indicator(self, 1) 
        #Downloading cinemas list
        threading.Thread(target=self.download_cinemas_list, args=(self.sites[self.defaultsite],)).start()

    def dialog_closed(self, data):
        if not (self.defaultsite == self.currentsite):
            self.defaultsite = self.currentsite
            self.write_config()
            self.start_thread()

    # menyy loomine
    def create_m5_menu(self, widget):
		menu = hildon.AppMenu()

		# Create menu entries
		btn_options = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		btn_options.set_label("Preferences")        
		# Attach callback to clicked signal
		btn_options.connect("clicked", self.btn_options_clicked)
		
		# Create menu entries
		btn_about = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
		btn_about.set_label("About")
		# Attach callback to clicked signal
		btn_about.connect("clicked", self.btn_about_clicked)
		
		# Add entry to the view menu
		menu.append(btn_options)
		menu.append(btn_about)
		
		menu.show_all()
		return menu

    def value_changed(self, button):
        i = self.sitenames.index(button.get_value())
        self.currentsite = i

    def create_cinema_selector(self):
        #Create a HildonTouchSelector with a single text column
        selector = hildon.TouchSelector(text = True)
        for caption in self.sitenames:
            selector.append_text(caption)
        selector.set_active(0, self.defaultsite)
        return selector

    def btn_options_clicked(self, button):        
        #Create options dialog
        dialog = gtk.Dialog()
        dialog.set_transient_for(self)
        dialog.set_title("Preferences")
        btn_options = hildon.PickerButton(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        btn_options.set_title("Change Company")
        #btn_options.set_value_alignment(.5, 1)
        selector = self.create_cinema_selector()
        btn_options.set_selector(selector)
        btn_options.connect("value-changed", self.value_changed)
        dialog.vbox.add(btn_options)
        dialog.connect('destroy', self.dialog_closed)	
        dialog.show_all()
        #dialog.run()
                
    def btn_about_clicked(self, button):        
        #Show About dialog
        note = hildon.hildon_note_new_information(self, \
        "Download and show todays schedule for cinemas:\n" \
        "Forum Cinemas Estonia, Forum Cinemas Latvia,\n" \
        "Forum Cinemas Lithuania, Finnkino Finland.")   
        gtk.Dialog.run(note)
        			
    def butt_cinema_click(self, button, index):        
        self.win = Window(self.sites[self.defaultsite], self.cinemas[0][index])
        self.win.set_title(self.cinemas[1][index])
        #Create a banner with a markup
        banner = hildon.hildon_banner_show_information(self.win, "None", "Downloading schedule")
	
    def download_cinemas_list(self, *args):
        #Clear previous buttons and list
        for item in self.vbox:
            self.vbox.remove(item)
        del self.cinemas[0:len(self.cinemas)]        
        try:
            id = []
            name = []
            #Download source and take cinema list       
            f = urllib.urlopen(args[0])
            #Find Cinema Names and ID-s
            while 1:
                line = f.readline()
                if line:
                    i = line.find('theatreId:')
                    if (i >= 0):
                        #Put cinema id into list
                        id.append(line[i+11:i+16])
                        result = line[line.find('">')+2:len(line)]
                        #Put cinema name into list
                        name.append(result[0:result.find('<')])
                        butt_cinema = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
                        butt_cinema.set_text(result[0:result.find('<')], "")
                        butt_cinema.connect("clicked", self.butt_cinema_click, len(id)-1)
                        self.vbox.pack_start(butt_cinema, False)                    
                else:
                    break
            f.close()
            self.cinemas.append(id)
            self.cinemas.append(name)
        except Exception, e:
            print 'Error: %s' % (str(e))
            #Create a banner with a markup
            banner = hildon.hildon_banner_show_information(self, "None", str(e))
        hildon.hildon_gtk_window_set_progress_indicator(self, 0)
        self.show_all()
                   
	def open_url(self, data):
		osso_rpc = osso.Rpc(ctx)
		osso_rpc.rpc_run("com.nokia.osso_browser","/com/nokia/osso_browser/request", 'com.nokia.osso_browser','load_url',rpc_args=('http://www.forum.nokia.com/',))

    def read_config(self):
        config = ConfigParser.SafeConfigParser()
        try:
            config.read('/home/user/.fSchedule')        
            self.defaultsite = int(config.get('default', 'defaultsite'))
        except Exception:
            self.defaultsite = 0

    def write_config(self):
        try:
            config = ConfigParser.SafeConfigParser()
            config.read('~/.fSchedule')
            config.set('default', 'defaultsite', str(self.defaultsite))
            # Writing our configuration file to 'example.cfg'
            config.write(open('/home/user/.fSchedule', 'w'))
        except Exception:
            #If there is no config file
            config_raw = ConfigParser.RawConfigParser()
            config_raw.add_section('default')
            config_raw.set('default', 'defaultsite', str(self.defaultsite))
            #Writing our new configuration to file '/home/user/.fSchedule'
            config_raw.write(open('/home/user/.fSchedule', 'wb'))        
        
class fSchedule(hildon.Program):
	def __init__(self):
	    #Make the hildon program
		hildon.Program.__init__(self)
		#Make main window with all its goodies
		self.window = MainWindow()

		gtk.main()

if __name__ == '__main__':
	fSchedule()