#include <iostream>

#include <glib.h>
#include <glib-object.h>
#include <libosso.h>

#include "SDL/SDL_audio.h"
#include "sound.hpp"

namespace {

GMainContext* maincontext = NULL;
GMainLoop* mainloop = NULL;
osso_context_t* osso_context = NULL;
bool display_off = false;

static gint osso_default_callback(const gchar* interface, const gchar* method,
                                  GArray *arguments, gpointer data, osso_rpc_t* retval) {

	std::cout << "DBUS INTERFACE:" << interface << " METHOD: " << method << "\n";
	if(retval) {
		retval->type = DBUS_TYPE_INVALID;
	//	retval->type = DBUS_TYPE_BOOLEAN;
	//	retval->value.b = true;
	}
	return OSSO_OK;
}

static gboolean display_off_loop(gpointer data) {
//	sound::pause_music();
	SDL_PauseAudio(1);
	while(display_off) {
		std::cout << "display_off loop\n";
		g_main_context_iteration(maincontext, true);
	}
//	sound::resume_music();
	SDL_PauseAudio(0);
	return false;
}

static void osso_display_event_callback(osso_display_state_t state, gpointer data) {
	switch(state) {
	case OSSO_DISPLAY_ON:
		std::cout << "DISPLAY ON\n";
		display_off = false;
		break;
	case OSSO_DISPLAY_OFF:
		std::cout << "DISPLAY OFF\n";
		display_off = true;
		g_idle_add(display_off_loop, NULL);
		break;
	case OSSO_DISPLAY_DIMMED:
		std::cout << "DISPLAY DIMMED\n";
		break;
	}
}

static void osso_hw_callback(osso_hw_state_t* state, gpointer data) {
//  gboolean shutdown_ind;
//  gboolean save_unsaved_data_ind;
//  gboolean memory_low_ind;
	if(state->system_inactivity_ind) {
		std::cout << "SYSTEM INACTIVE\n";
	} else {
		std::cout << "SYSTEM ACTIVE\n";
	}

	switch(state->sig_device_mode_ind) {
	case OSSO_DEVMODE_NORMAL:
		std::cout << "NORMAL MODE\n";
		break;
	case OSSO_DEVMODE_FLIGHT:
		std::cout << "FLIGHT MODE\n";
		break;
	default:
		std::cout << "UNKNOWN MODE\n";
		break;
	}
}

}

namespace osso {

int init() {
	g_type_init();
	maincontext = g_main_context_default();
	mainloop = g_main_loop_new(maincontext, false);
	osso_context = osso_initialize("com.frogatto.game", "1.0", 0, maincontext);

	if(!osso_context) {
		std::cerr << "could not initialize libosso\n";
		return -1;
	}

	osso_return_t ret;
	ret = osso_rpc_set_default_cb_f(osso_context, osso_default_callback, NULL);
	if(ret != OSSO_OK) {
		std::cerr << "could not register osso callback\n";
		return -1;
	}

	ret = osso_hw_set_event_cb(osso_context, NULL, osso_hw_callback, NULL);
	if(ret != OSSO_OK) {
		std::cerr << "could not register osso device state callback\n";
		return -1;
	}

	ret = osso_hw_set_display_event_cb(osso_context, osso_display_event_callback, NULL);
	if(ret != OSSO_OK) {
		std::cerr << "could not register osso display event callback\n";
		return -1;
	}

	return 0;
}

void process() {
	if (maincontext == NULL || osso_context == NULL)
		return;

	g_main_context_iteration(maincontext, false);
}

}
