#include "ffmwidget.h"
#include "ffmsettingsdialog.h"

FFMSettingsDialog::FFMSettingsDialog(FFMWidget * widget)
    : QDialog(0)
    , mWidget(widget)
{
    ui.setupUi(this);

    if (mWidget->isFMBoostActivated())
    {
        ui.boostCheckBox->setChecked(true);
    }
    else
    {
        ui.boostCheckBox->setChecked(false);
    }

    ui.preset1SpinBox->setMinimum(mWidget->getMinFrequency() / 1000.0);
    ui.preset1SpinBox->setMaximum(mWidget->getMaxFrequency() / 1000.0);
    ui.preset1SpinBox->setValue(mWidget->getPreset1() / 1000.0);

    ui.preset2SpinBox->setMinimum(mWidget->getMinFrequency() / 1000.0);
    ui.preset2SpinBox->setMaximum(mWidget->getMaxFrequency() / 1000.0);
    ui.preset2SpinBox->setValue(mWidget->getPreset2() / 1000.0);
}

void FFMSettingsDialog::updateUi()
{
    if (mWidget->isFMBoostInstalled())
    {
        ui.boostCheckBox->setEnabled(true);
        ui.boostCheckBox->setText("Use FM Boost");
    }
    else
    {
        ui.boostCheckBox->setEnabled(false);
        ui.boostCheckBox->setText("Use FM Boost (not installed)");
    }
}

bool FFMSettingsDialog::getBoostCheckBoxState()
{
    return ui.boostCheckBox->checkState() == Qt::Checked ? true : false;
}

uint FFMSettingsDialog::getPreset1SpinBoxValue()
{
    double v = ui.preset1SpinBox->value();
    return qRound(v * 10.0) * 100;
}

uint FFMSettingsDialog::getPreset2SpinBoxValue()
{
    double v = ui.preset2SpinBox->value();
    return qRound(v * 10.0) * 100;
}

