/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FFMWIDGET_H
#define FFMWIDGET_H

#include "ffmsimplebutton.h"
#include "ffmtogglebutton.h"
#include "ffmdoublebutton.h"
#include "ffmsettingsdialog.h"

#include <QtGui>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusConnection>

class FFMWidget : public QWidget
{
    Q_OBJECT

public:
    FFMWidget();
    ~FFMWidget();

    QSize sizeHint() const;

    inline bool isFMBoostInstalled();
    inline bool isFMBoostActivated();

public slots:
    void showSettingsDialog();
    void incrementFrequency();
    void decrementFrequency();
    void switchFMTransmitter();
    void switchBTRadio();

    void fmPropertyChanged();
    void btPropertyChanged(QString property, QDBusVariant value);

    void fmBoostChanged(int state);

protected:
    bool mBtOn, mTmOn;
    bool mFMBoostInstalled, mFMBoostActivated;
    uint mFreqStep, mFreqMin, mFreqMax, mFreqCurrent;

    FFMSimpleButton mLeftButton, mRightButton;
    FFMToggleButton mMiddleButton;
    FFMDoubleButton mTopButton;
    FFMSettingsDialog *mSettingsDlg;

    QSettings mSettings;
    QDBusConnection mSystemBus;
    QDBusInterface * mFMIface;
    QDBusInterface * mBTIface;
};


inline bool FFMWidget::isFMBoostInstalled()
{
    return mFMBoostInstalled;
}

inline bool FFMWidget::isFMBoostActivated()
{
    return mFMBoostActivated;
}

#endif
