/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "ffmbutton.h"

FFMButton::FFMButton(const char * backgroundPath, const char * backgroundPressedPath, QWidget *parent)
    : QLabel(parent)
    , mBackground(backgroundPath)
    , mBackgroundPressed(backgroundPressedPath)
{
    setPixmap(mBackground);
}

void FFMButton::mousePressEvent(QMouseEvent *)
{
    if (!mBackgroundPressed.isNull())
    {
        setPixmap(mBackgroundPressed);
    }
}

void FFMButton::mouseReleaseEvent(QMouseEvent *event)
{
    if (geometry().contains(mapToParent(event->pos())))
    {
        emit clicked();
    }
    setPixmap(mBackground);
}

void FFMButton::mouseMoveEvent(QMouseEvent *event)
{
    if (!geometry().contains(mapToParent(event->pos())))
    {
        setPixmap(mBackground);
    }
}
