/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FFMTOGGLEBUTTON_H
#define FFMTOGGLEBUTTON_H

#include "ffmsimplebutton.h"

#include <QtGui>

class FFMToggleButton : public FFMSimpleButton
{
    Q_OBJECT

public:
    FFMToggleButton(const char * backgroundPath, const char * backgroundPressedPath, const char * iconPath, const char * iconPressedPath, QWidget *parent = 0);

    void setOn(bool on);

protected:
    void paintEvent(QPaintEvent *event);

private:
    bool mOn;
    QPixmap mIconPressed;
};

#endif // FFMTOGGLEBUTTON_H
