/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "ffmtogglebutton.h"

FFMToggleButton::FFMToggleButton(const char * backgroundPath, const char * backgroundPressedPath, const char * iconPath, const char * iconPressedPath, QWidget *parent)
    : FFMSimpleButton(backgroundPath, backgroundPressedPath, iconPath, parent)
    , mOn(false)
    , mIconPressed(iconPressedPath)
{
}

void FFMToggleButton::setOn(bool on)
{
    if (mOn != on)
    {
        mOn = on;
        repaint();
    }
}

void FFMToggleButton::paintEvent(QPaintEvent *event)
{
    FFMButton::paintEvent(event);

    QPainter p(this);
    if (mOn)
    {
        p.drawPixmap(mIconPos, mIconPressed);
    }
    else
    {
        p.drawPixmap(mIconPos, mIcon);
    }
    p.end();
}
