/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "ffmdoublebutton.h"

FFMDoubleButton::FFMDoubleButton(const char * backgroundPath, const char * backgroundPressedPath, const char * btIconPath, const char * btOnIconPath, const char * tmIconPath, const char * tmOnIconPath, QWidget *parent)
    : FFMButton(backgroundPath, backgroundPressedPath, parent)
    , mFrequency(0)
    , mBtOn(false)
    , mTmOn(false)
    , mBtIcon(btIconPath)
    , mBtOnIcon(btOnIconPath)
    , mTmIcon(tmIconPath)
    , mTmOnIcon(tmOnIconPath)
{
    mTmIconPos.setX(((64 - mTmIcon.width()) / 2) + 16);
    mTmIconPos.setY(((64 - mTmIcon.height()) / 2) + ((mBackground.height() - 61) / 2));
    mBtIconPos.setX(((64 - mBtIcon.width()) / 2) + (mBackground.width() - mBackground.height()));
    mBtIconPos.setY(((64 - mBtIcon.height()) / 2) + ((mBackground.height() - 61) / 2));
    mFreqPos.setX(130);
    mFreqPos.setY(40);
}

void FFMDoubleButton::setBtOn(bool on)
{
    if (mBtOn != on)
    {
        mBtOn = on;
        repaint();
    }
}

void FFMDoubleButton::setTmOn(bool on)
{
    if (mTmOn != on)
    {
        mTmOn = on;
        repaint();
    }
}

void FFMDoubleButton::setFrequency(int frequency)
{
    if (frequency != mFrequency)
    {
        mFrequency = frequency;
        repaint();
    }
}

void FFMDoubleButton::paintEvent(QPaintEvent *event)
{
    FFMButton::paintEvent(event);

    QPainter p(this);
    if (mBtOn)
    {
        p.drawPixmap(mBtIconPos, mBtOnIcon);
    }
    else
    {
        p.drawPixmap(mBtIconPos, mBtIcon);
    }
    if (mTmOn)
    {
        p.drawPixmap(mTmIconPos, mTmOnIcon);
    }
    else
    {
        p.drawPixmap(mTmIconPos, mTmIcon);
    }
    QFont f = p.font();
    f.setPointSize(15);
    p.setFont(f);
    p.drawText(mFreqPos, QString("%1 MHz").arg((float) mFrequency / 1000.0, 0, 'f', 1));
    p.end();
}

void FFMDoubleButton::mouseReleaseEvent(QMouseEvent *event)
{
    QRect btRect(mBackground.width() - mBackground.height(), 0, mBackground.height(), mBackground.height());
    if (btRect.contains(mapToParent(event->pos())))
    {
        emit clicked();
    }
}
