/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Gopalakrishna Bhat A <gopalakbhat@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "IndividualFile.h"

#include <QFileDialog>
#include <QCheckBox>
#include <QPushButton>
#include <QDesktopServices>
#include <QHBoxLayout>

IndividualFile::IndividualFile(QString text, QWidget *parent) :
        QWidget(parent)
{
    filePath=new QCheckBox(text,this);
    browse=new QPushButton(tr("Browse"),this);
    connect(browse,SIGNAL(clicked()),this,SLOT(browseClicked()));

    QHBoxLayout *hlayout=new QHBoxLayout(this);
    hlayout->addWidget(filePath,2);
    hlayout->addWidget(browse,0);

    setLayout(hlayout);

}

void IndividualFile::browseClicked()
{
    QString fileName=QFileDialog::getOpenFileName(this,tr("File"),QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation));
    if(!fileName.isEmpty()) {
        filePath->setText(fileName);
        filePath->setChecked(true);
    }
}

void IndividualFile::setChecked(bool checked)
{
    filePath->setChecked(checked);
}

QString IndividualFile::fileName()
{
    return filePath->text();
}

bool IndividualFile::isChecked()
{
    return filePath->isChecked();
}
