#include "addtipdialog.h"
#include <QGridLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QDebug>
#include <QMaemo5InformationBox>

AddTipDialog::AddTipDialog(QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation);

    fsc = FoursquareComm::instance();

    QGridLayout* layout = new QGridLayout(this);
    QLabel * l2 = new QLabel("Your tip:");
    layout->addWidget(l2,1,1);
    tip = new QLineEdit();
    layout->addWidget(tip,1,2);

    QLabel * l3 = new QLabel("Website:");
    layout->addWidget(l3,2,1);
    url = new QLineEdit();
    url->setPlaceholderText("Optional");
    layout->addWidget(url,2,2);

    QPushButton * pbSubmit = new QPushButton("Add Tip");
    layout->addWidget(pbSubmit,2,3);

    setWindowTitle(tr("Add tip"));
    connect(pbSubmit,SIGNAL(clicked()),this,SLOT(submitButtonClicked()));
}
void AddTipDialog::setVenue(f_venue v)
{
    setWindowTitle("Add tip for "+v.name);
    this->venue = v;
}

void AddTipDialog::submitButtonClicked()
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    f_tip t = fsc->addTip(venue.id,tip->text(),url->text());
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
    if(t.text!="")
        QMaemo5InformationBox::information(this, "<p>Tip added.</p>", QMaemo5InformationBox::DefaultTimeout);
    this->close();
}
