#include "recentcheckinswindow.h"
#include "ui_recentcheckinswindow.h"
#include <QListWidgetItem>
#include <QDebug>
#include <QLabel>
#include <QTreeWidgetItem>
#include <QDateTime>

RecentCheckinsWindow::RecentCheckinsWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::RecentCheckinsWindow)
{
    ui->setupUi(this);
    #if defined(Q_WS_MAEMO_5)
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif
    this->setWindowFlags(this->windowFlags()| Qt::Window);

    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);

    fsc = FoursquareComm::instance();
    ic = new ImageCache(this);

    this->lastresult = fsc->getRecentCheckins();
    parseAndShowResult();
}

RecentCheckinsWindow::~RecentCheckinsWindow()
{
    delete ui;
}

void RecentCheckinsWindow::parseAndShowResult()
{
    for (int i = 0; i < lastresult.size(); ++i) {
        QTreeWidgetItem* item = new QTreeWidgetItem(ui->twRecent);
        item->setIcon(0,QIcon(ic->getImage(lastresult.at(i).user.photo)));
        item->setText(1,lastresult.at(i).user.firstName + " " + lastresult.at(i).user.lastName + "\n@ "+lastresult.at(i).venue.name);
        QDateTime timestamp;
        timestamp.setTime_t(lastresult.at(i).createdAt.toUInt());
        item->setText(2,timestamp.toString(Qt::SystemLocaleShortDate));
    }
    for(int i = 0; i< ui->twRecent->columnCount(); i++)
            ui->twRecent->resizeColumnToContents(i);
}
