#include "positionsource.h"

PositionSource* PositionSource::inst = NULL;

PositionSource *PositionSource::instance()
{
    if (!inst)
        inst = new PositionSource();
    return inst;
}

PositionSource::PositionSource()
{
    // Emit updates every 2 seconds if available
    gpisource = QGeoPositionInfoSource::createDefaultSource(0);
    if (gpisource)
    {
        gpisource->setUpdateInterval(2000);
        connect(gpisource, SIGNAL(positionUpdated(QGeoPositionInfo)),this, SLOT(positionUpdated(QGeoPositionInfo)));
        gpisource->startUpdates();
    }
}

void PositionSource::positionUpdated(QGeoPositionInfo gpi)
{
    this->gc = gpi.coordinate();
    //qDebug() << "positionUpdated";
}

bool PositionSource::isValidPosition()
{
    return gc.isValid();
}

QString PositionSource::getLL()
{
    if(!gc.isValid())
        return "";
    QString ll;
    ll = QString::number(this->gc.latitude());
    ll.append(',');
    ll.append(QString::number(this->gc.longitude()));
    return ll;
}
